package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.domain.CommonDictMapper;
import com.bxm.localnews.admin.service.base.CommonDictService;
import com.bxm.localnews.admin.vo.CommonDict;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 数据字典service
 *
 * @author zhaoxin
 */

@Service
public class CommonDictServiceImpl implements CommonDictService {

    private final CommonDictMapper commonDictMapper;

    @Autowired
    public CommonDictServiceImpl(CommonDictMapper commonDictMapper) {
        this.commonDictMapper = commonDictMapper;
    }

    @Override
    public CommonDict getById(Long id) {
        return commonDictMapper.getById(id);
    }

    @Override
    public List<CommonDict> listJobByParentId(Long parentId) {
        return commonDictMapper.listJobByParentId(parentId);
    }
}
