package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.service.base.ShortLinkService;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Optional;

import static com.bxm.localnews.admin.constant.RedisConfig.SHORT_URL;

@Service
@AllArgsConstructor
public class ShortLinkServiceImpl implements ShortLinkService {

    private RedisStringAdapter redisStringAdapter;

    private DomainIntegrationService domainIntegrationService;

    @Override
    public String getShortUrl(String url, boolean expired) {
        //短连接地址
        StringBuilder sortUrl = new StringBuilder();
        // 获取短链的base url
        Optional<AvailableDomainInfo> baseUrlInfoByScene = domainIntegrationService.getBaseUrlInfoByScene(DomainScene.SHORT,
                null, null);

        sortUrl.append(baseUrlInfoByScene.isPresent() ? baseUrlInfoByScene.get().getBaseUrl() : "").append("t").append("/");
        String key = ShortUrlGenerator.getShortUrl(url)[0];
        sortUrl.append(key);
        //缓存180天，超时，则跳转到注册界面
        if (expired) {
            this.redisStringAdapter.set(SHORT_URL.copy().appendKey(key), url, 3600 * 24 * 90L);
        } else {
            this.redisStringAdapter.set(SHORT_URL.copy().appendKey(key), url);
        }
        return sortUrl.toString();
    }

    @Override
    public String getPrivilegeShareShortLink(String param) {
        String url = null;
        // 2020-08-04 17:24:47 域名防封功能开发时，发现这里改动很麻烦，又不用，就先舍弃了
        url = "" + "?" + param;
        return getShortUrl(url, true);
    }

}
