package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.domain.UserTagMapper;
import com.bxm.localnews.admin.service.base.UserCommonTagService;
import com.bxm.localnews.admin.service.base.UserTagService;
import com.bxm.localnews.admin.vo.UserCommonTag;
import com.bxm.localnews.admin.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Log4j2
@Service
public class UserTagServiceImpl extends BaseService implements UserTagService {

    @Autowired
    private UserCommonTagService userCommonTagService;

    @Autowired
    private UserTagMapper userTagMapper;

    @Override
    public void save(Long userId, List<Long> userCommonTagIds) {
        if (null == userId || CollectionUtils.isEmpty(userCommonTagIds)) {
            return;
        }
        Map<Long, UserCommonTag> userCommonTagMap = userCommonTagService.getUserCommonTagMap();

        List<UserCommonTag> userCommonTags = userCommonTagIds.stream()
                .map(userCommonTagMap::get)
                .sorted(Comparator.comparing(UserCommonTag::getOrder))
                .collect(Collectors.toList());

        userTagMapper.batchInsert(convertToUserTags(userId, userCommonTags));

    }

    private List<UserTag> convertToUserTags(Long userId, List<UserCommonTag> userCommonTags) {
        List<UserTag> userTags = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userCommonTags)) {
            for (int i = 0; i < userCommonTags.size(); i++) {
                UserTag userTag = new UserTag();
                userTag.setId(nextSequence());
                userTag.setLabel(userCommonTags.get(i).getLabel());
                userTag.setOrder(i);
                userTag.setUserId(userId);
                userTag.setDefaultFlag((byte) 1);
                userTag.setCreateTime(new Date());
                userTags.add(userTag);
            }

        }
        return userTags;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(Long userId, List<Long> userCommonTagIds) {
        if (null == userId) {
            return;
        }
        // 删除用户标签
        userTagMapper.deleteAll(userId);
        this.save(userId, userCommonTagIds);
    }
}
