package com.bxm.localnews.admin.service.im;

import com.bxm.localnews.admin.param.CreateTimingRedPacketPlanParam;
import com.bxm.localnews.admin.param.IdParam;
import com.bxm.localnews.admin.param.ListPlansByChatRoomIdParam;
import com.bxm.localnews.admin.param.UpdateTimingRedPacketPlanParam;
import com.bxm.localnews.admin.vo.im.ImTimingRedPacketPlanVO;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author Gonzo
 * @date 2019-11-01 13:56
 */
public interface ImChatRoomRedPacketService {
    /**
     * 根据聊天室id查询所有定时红包计划
     *
     * @return
     */
    PageWarper<ImTimingRedPacketPlanVO> listPlansByChatRoomId(ListPlansByChatRoomIdParam param);

    /**
     * 创建聊天室定时红包计划
     *
     * @param param
     *
     * @return
     */
    Json createTimingRedPacketPlan(CreateTimingRedPacketPlanParam param);

    /**
     * 编辑聊天室定时红包计划
     */
    Json updateTimingRedPacketPlan(UpdateTimingRedPacketPlanParam param);

    /**
     * 删除聊天室定时红包计划
     *
     * @param param
     *
     * @return
     */
    Json deleteTimingRedPacketPlan(IdParam param);
}
