package com.bxm.localnews.admin.service.market;

import com.bxm.localnews.admin.param.MarketOrderQueryParam;
import com.bxm.localnews.admin.vo.MarketOrder;
import com.bxm.localnews.admin.vo.MarketOrderExpressage;
import com.bxm.newidea.component.vo.PageWarper;

import javax.servlet.http.HttpServletResponse;

/**
 * 订单管理服务
 */
public interface MarketOrderService {

    /**
     * 查询订单
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<MarketOrder> getList(MarketOrderQueryParam param);

    /**
     * 新增或编辑物流信息
     *
     * @param marketOrderExpressage
     * @return
     */
    int saveOrUpdate(MarketOrderExpressage marketOrderExpressage);

    /**
     * 导出excel
     *
     * @param param
     * @param response
     */
    void exportExcel(MarketOrderQueryParam param, HttpServletResponse response);
}
