package com.bxm.localnews.admin.service.market.impl;

import com.bxm.localnews.admin.domain.GoldFlowMapper;
import com.bxm.localnews.admin.enums.GoldFlowTypeEnum;
import com.bxm.localnews.admin.param.GoldFlowQueryParam;
import com.bxm.localnews.admin.service.market.GoldFlowService;
import com.bxm.localnews.admin.utils.ExportUtils;
import com.bxm.localnews.admin.utils.dto.ExportDataRow;
import com.bxm.localnews.admin.utils.dto.ExportModel;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@Service
public class GoldFlowServiceImpl implements GoldFlowService {
    private static final Logger logger = LoggerFactory.getLogger(GoldFlowServiceImpl.class);

    @Resource
    private GoldFlowMapper goldFlowMapper;

    @Override
    public List<String> getTypeList() {
        List<String> typeList = new ArrayList<>();

        for (GoldFlowTypeEnum typeEnum : GoldFlowTypeEnum.values()) {
            typeList.add(typeEnum.getDesc());
        }

        return typeList;
    }

    @Override
    public PageWarper<GoldFlow> getList(GoldFlowQueryParam param) {
        param.setType(GoldFlowTypeEnum.getNameByDesc(param.getType()));
        return new PageWarper<>(goldFlowMapper.getList(param));
    }

    @Override
    public void exportExcel(GoldFlowQueryParam param, HttpServletResponse response) {
        param.setPageNum(1);
        param.setPageSize(20000);
        List<GoldFlow> goldFlowList = goldFlowMapper.getList(param);

        try {
            String fileName = "红花明细.xls";
            String headNames = "流水id,用户id,流水类型,变更数量,变更类型,创建时间";

            // 构造excel数据模型
            ExportModel exportModel = new ExportModel();
            exportModel.setHeadNames(headNames);

            List<ExportDataRow> dataRowList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(goldFlowList)) {
                for (GoldFlow goldFlow : goldFlowList) {
                    ExportDataRow exportDataRow = new ExportDataRow();
                    List<String> dataColumnList = new ArrayList<>();

                    dataColumnList.add(goldFlow.getId() + "");
                    dataColumnList.add(goldFlow.getUserId() + "");
                    dataColumnList.add(GoldFlowTypeEnum.getDescByName(goldFlow.getType()));
                    dataColumnList.add(goldFlow.getAmount() + "");
                    dataColumnList.add(goldFlow.getAmount() >= 0 ? "收入" : "支出");
                    dataColumnList.add(DateUtils.formatDateTime(goldFlow.getCreateTime()));

                    exportDataRow.setDataColumnList(dataColumnList);
                    dataRowList.add(exportDataRow);
                }
            }
            exportModel.setDataRowList(dataRowList);

            byte[] result = ExportUtils.makeExcel(exportModel, fileName);
            ExportUtils.exportToResponse(response, fileName, result, "excel");
        } catch (Exception e) {
            logger.error("导出金币流水失败：", e);
        }
    }

}
