package com.bxm.localnews.admin.service.medal;

import com.bxm.localnews.admin.param.medal.ConfirmRecordParam;
import com.bxm.localnews.admin.param.medal.MedalGrantQueryParam;
import com.bxm.localnews.admin.param.medal.SaveCustomMedalGrantParam;
import com.bxm.localnews.admin.vo.medal.CustomGrantDetailVO;
import com.bxm.localnews.admin.vo.medal.MedalGrantListVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 勋章发放管理service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/2 3:47 下午
 */
public interface MedalGrantManageService {
    /**
     * 获取定制勋章发放列表
     *
     * @param param 查询入参
     * @return 勋章发放列表
     */
    PageWarper<MedalGrantListVO> getGrantList(MedalGrantQueryParam param);

    /**
     * 保存或修改勋章发放记录
     *
     * @param param 入参
     * @return 执行结果
     */
    Message saveOrUpdateGrant(SaveCustomMedalGrantParam param);

    /**
     * 确认发放
     *
     * @param param 入参
     * @return 执行结果
     */
    Message confirmGrant(ConfirmRecordParam param);

    /**
     * 取消发放
     *
     * @param param 入参
     * @return 执行结果
     */
    Message cancelGrant(@RequestBody ConfirmRecordParam param);

    /**
     * 获取勋章发放信息详情
     *
     * @param grantRecordId 发放记录id
     * @return 定制勋章发放信息详情
     */
    CustomGrantDetailVO getMedalGrantDetail(Long grantRecordId);

    /**
     * 授予用户定制勋章
     */
    void grantCustomMedal();
}