package com.bxm.localnews.admin.service.medal;

import com.bxm.localnews.admin.param.medal.MedalQueryParam;
import com.bxm.localnews.admin.param.medal.SaveCustomMedalParam;
import com.bxm.localnews.admin.vo.medal.CustomMedalDetailVO;
import com.bxm.localnews.admin.vo.medal.CustomMedalSelectVO;
import com.bxm.localnews.admin.vo.medal.MedalListVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 勋章管理Service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/1 4:52 下午
 */
public interface MedalManageService {

    /**
     * 获取所有定制勋章的列表
     *
     * @param param 查询入参
     * @return 分页定制勋章列表
     */
    PageWarper<MedalListVO> getCustomMealList(MedalQueryParam param);

    /**
     * 保存或更新定制勋章信息
     *
     * @param param 入参
     * @return 执行结果
     */
    Message saveOrUpdateCustomMedal(SaveCustomMedalParam param);

    /**
     * 获取所有可用的定制勋章列表
     *
     * @param keyword 搜索关键字
     * @return 可用的定制勋章列表
     */
    List<CustomMedalSelectVO> getUsableCustomMedalList(String keyword, Integer allType);

    /**
     * 获取定制勋章详情
     *
     * @param medalId 勋章id
     * @return 定制勋章详情对象
     */
    CustomMedalDetailVO getMedalDetail(Long medalId);

    /**
     * 下线过期的定制勋章
     */
    void offlineExpiredCustomMedal();
}