package com.bxm.localnews.admin.service.medal;

import com.bxm.localnews.admin.param.medal.UserCustomMedalParam;
import com.bxm.localnews.admin.vo.medal.UserMedalInfoVO;
import com.bxm.newidea.component.vo.Message;

/**
 * 用户勋章管理service接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/2 3:48 下午
 */
public interface UserMedalManageService {

    /**
     * 获取用户的勋章信息
     *
     * @param userId 用户id
     * @return 用户的勋章信息
     */
    UserMedalInfoVO getUserMedalInfo(Long userId);

    /**
     * 删除用户的定制勋章信息
     *
     * @param param 入参
     * @return 执行结果
     */
    Message removeUserCustomMedal(UserCustomMedalParam param);

    /**
     * 获取用户勋章数量（勋章数量等于：成就勋章的数量（同一个等级算一个）+ 定制勋章的数量）
     *
     * @param userId 用户id
     * @return 勋章总数
     */
    int getUserMedalNum(Long userId);
}