package com.bxm.localnews.admin.service.medal.impl;

import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.domain.medal.UserMedalInfoMapper;
import com.bxm.localnews.admin.domain.medal.UserMedalRelationInfoMapper;
import com.bxm.localnews.admin.entity.medal.UserMedalInfoEntity;
import com.bxm.localnews.admin.integration.PushMsgIntegrationService;
import com.bxm.localnews.admin.param.medal.UserCustomMedalParam;
import com.bxm.localnews.admin.service.medal.UserMedalManageService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.medal.CustomMedalVO;
import com.bxm.localnews.admin.vo.medal.UserMedalInfoVO;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/2 4:42 下午
 */
@Service
@AllArgsConstructor
public class UserMedalManageServiceImpl implements UserMedalManageService {

    private UserMedalRelationInfoMapper medalRelationInfoMapper;

    private PushMsgIntegrationService pushMsgIntegrationService;

    private UserMedalInfoMapper userMedalInfoMapper;

    private UserMapper userMapper;

    @Override
    public UserMedalInfoVO getUserMedalInfo(Long userId) {
        UserMedalInfoVO resultVO = new UserMedalInfoVO();

        User currentUserInfo = userMapper.selectByUserId(userId);

        resultVO.setUserId(userId);
        resultVO.setPhone(currentUserInfo.getPhone());
        resultVO.setNickname(currentUserInfo.getNickname());

        //用户勋章总数
        resultVO.setMedalNum(getUserMedalNum(userId));

        //设置成就勋章数据
        resultVO.setAchievementMedalList(medalRelationInfoMapper.getUserAchievementMedalList(userId));

        //设置定制勋章数据
        List<CustomMedalVO> userCustomMedalList = medalRelationInfoMapper.getUserCustomMedalList(userId);
        for (CustomMedalVO customMedalVO : userCustomMedalList) {
            String grantTimeStr = DateUtils.formatDateTime(customMedalVO.getGrantTime());
            String expiredTimeStr = DateUtils.formatDateTime(customMedalVO.getExpiredTime());
            customMedalVO.setEffectiveRange(grantTimeStr + "-" + expiredTimeStr);
        }

        resultVO.setCustomMedalList(userCustomMedalList);

        return resultVO;
    }

    @Override
    public Message removeUserCustomMedal(UserCustomMedalParam param) {

        UserMedalInfoEntity userMedalInfoEntity = userMedalInfoMapper.selectByPrimaryKey(param.getMedalId());

        if (Objects.isNull(userMedalInfoEntity)) {
            return Message.build(false, "该勋章信息不存在");
        }

        medalRelationInfoMapper.removeUserMedalByUserIdAndMedalId(param.getUserId(), param.getMedalId(), param.getNotifyReason());

        //如果需要通知用户，则发送删除原因推送
        if (Objects.nonNull(param.getNotifyUser()) && param.getNotifyUser()) {
            pushMsgIntegrationService.pushRemoveUserCustomMedalMsg(param.getUserId(), userMedalInfoEntity.getName(), param.getNotifyReason());
        }

        return Message.build(true);
    }

    @Override
    public int getUserMedalNum(Long userId) {
        //用户勋章数量=成就勋章+定制勋章
        int achievementMedalNum = medalRelationInfoMapper.countUserAchievementMedalNum(userId);
        int customMedalNum = medalRelationInfoMapper.countUserCustomMedalNum(userId);

        return achievementMedalNum + customMedalNum;
    }
}