package com.bxm.localnews.admin.service.medal.impl;

import com.bxm.localnews.admin.dto.UserGrantMedalDTO;
import com.bxm.localnews.admin.service.medal.UserMedalPopService;
import com.bxm.localnews.admin.service.medal.cache.UserMedalPopCacheManager;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 用户勋章弹窗service实现类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/8 12:46 下午
 */
@Service
@Slf4j
@AllArgsConstructor
public class UserMedalPopServiceImpl implements UserMedalPopService {

    private UserMedalPopCacheManager userMedalPopCacheManager;

    @Override
    public UserGrantMedalDTO getUserMedalPopData(Long userId) {
        return userMedalPopCacheManager.getUserMedalPopCache(userId);
    }
}