package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.vo.AdminMenu;
import com.bxm.localnews.admin.vo.security.AdminMenuAdapterDTO;

import java.util.List;

/**
 * @author zhaoyadong
 */
public interface AdminMenuService {

    /**
     * 根据角色获取菜单
     *
     * @param roleId
     * @return 菜单列表
     */
    List<AdminMenuDTO> getMenusByRoleId(Integer roleId);

    /**
     * 根据角色ID获取菜单，返回适配VUE路由的菜单模型
     *
     * @param roleId 角色ID
     * @return 适配菜单模型
     */
    List<AdminMenuAdapterDTO> getMenuAdapter(Integer roleId);

    /**
     * 根据角色获取菜单
     *
     * @param roleId
     * @return 菜单列表
     */
    List<AdminMenuDTO> getMenusByRole(Long roleId);

    /**
     * 获取所有菜单列表
     *
     * @return 菜单列表
     */
    List<AdminMenuDTO> getAllMenu();

    /**
     * 获取菜单信息
     *
     * @param menuId
     * @return
     */
    AdminMenu selectByPrimaryKey(Integer menuId);

    /**
     * 获取父级菜单
     *
     * @return
     */
    List<AdminMenu> getParentMenus();

    /**
     * 更新菜单信息
     *
     * @param menu
     * @return 更新的行数
     */
    int update(AdminMenu menu);

    /**
     * 新增数据
     *
     * @param menu
     * @return
     */
    int insert(AdminMenu menu);

    /**
     * 根据菜单id删除菜单
     *
     * @param menuid
     * @return
     */
    int deleteByPrimaryKey(Integer menuid);

    /**
     * 根据角色id获取菜单列表
     *
     * @param roleId
     * @return
     */
    List<MenuDTO> getMenusAndPermsByRoleId(Integer roleId);
}
