package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.param.security.UserPhoneParam;
import com.bxm.localnews.admin.vo.MerchantUserVO;
import com.bxm.localnews.admin.vo.User;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/18.
 */
public interface AdminUserBaseInfoService {

    /**
     * 获取用户信息
     *
     * @param param
     * @return 分页结果
     */
    PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param);

    /**
     * 查询用户信息
     *
     * @param userId ： 用户id
     * @return 用户信息
     */
    User selectByUserId(Long userId);

    /**
     * 设置和取消用户黑名单
     *
     * @param map
     * @return
     */
    boolean updateUserBlack(Map<String, Object> map);

    /**
     * 删除用户
     *
     * @param userId
     * @return 获取虚拟用户列表
     */
    Boolean deleteUser(Long userId);

    /**
     * 获取虚拟用户列表
     *
     * @return 用户列表
     */
    List<UserInfoDTO> getVirtualUserList();

    /**
     * 修改用户手机号码
     * 如果手机号码已经被其他用户绑定则更新失败
     * 如果手机号码与当前用户一致，则提示无需修改
     *
     * @param param 更新参数
     * @return 变更结果
     */
    Message modifyPhoneNo(UserPhoneParam param);

    /**
     * 获取所有商家用户列表
     *
     * @param nickname 这里传入的可能是用户id或者用户昵称，如果传入的是数值类型就按照id去查
     * @return 所有商家用户列表
     */
    List<MerchantUserVO> queryMerchantUserList(String nickname);

}
