package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.dto.BatchActiveDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;

import java.util.List;

/**
 * @author gonzo
 * @date 2020-07-24 11:51
 **/
public interface VipCardService {
    /**
     * 临时的批量手机号激活、增加次数
     * 先把手机号存储到缓存
     * 触发一次缓存获取并增加次数
     *
     * @param phones 换行符分割的手机号
     * @return 每一个手机号激活的成功信息
     */
    List<ImportResultDTO> batchSavePhoneActive(String phones);

    /**
     * 查询缓存中的所有手机号
     * 没有做分页，一次性全部返回的
     * @return
     */
    List<BatchActiveDTO> listAllPhones();

    /**
     * 将缓存中的手机号进行处理
     * 1. 判断是否注册用户
     * 2. 已注册用户判断是否激活vip，未激活进行手动激活
     * 3. 已激活vip判断是否增加500次机会
     */
    void batchPhoneActive();
}
