package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.constant.VipCardRedisKey;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.BatchActiveDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.integration.UserVipIntegrationService;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author gonzo
 * @date 2020-07-24 11:05
 **/
@Slf4j
@Service
public class VipCardServiceImpl implements VipCardService {

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private UserVipIntegrationService userVipIntegrationService;

    @Autowired
    private AdminUserBaseInfoService adminUserBaseInfoService;

    @Override
    public List<ImportResultDTO> batchSavePhoneActive(String phones) {
        if (StringUtils.isBlank(phones)) {
            return Collections.emptyList();
        }

        // 添加到激活的队列中
        Arrays.stream(phones.split("\n"))
                .forEach(p -> {
                    BatchActiveDTO activeDTO = new BatchActiveDTO();
                    activeDTO.setPhone(p);
                    activeDTO.setHasActived(0);
                    activeDTO.setActiveTime(null);

                    redisHashMapAdapter.put(VipCardRedisKey.BATCH_ACTIVE_PHONE, p, activeDTO);
                });

        // 调用激活方法
        batchPhoneActive();
        return Collections.emptyList();
    }

    @Override
    public List<BatchActiveDTO> listAllPhones() {
        return redisHashMapAdapter.values(VipCardRedisKey.BATCH_ACTIVE_PHONE, BatchActiveDTO.class);
    }

    @Override
    public void batchPhoneActive() {
        List<BatchActiveDTO> batchActiveDTOS = redisHashMapAdapter.values(VipCardRedisKey.BATCH_ACTIVE_PHONE, BatchActiveDTO.class);

        // 查找用户
        batchActiveDTOS.forEach(p -> {
            if (Objects.equals(p.getHasActived(), 1)) {
                // 已激活处理过 跳过
                return;
            }
            // 查询用户信息
            UserInfoParam param = new UserInfoParam();
            param.setPhone(p.getPhone());
            PageWarper<UserInfoDTO> userInfoDTOS = adminUserBaseInfoService.queryUserInfoDTO(param);
            if (CollectionUtils.isEmpty(userInfoDTOS.getList())) {
                log.info("手机号: {} 不存在用户 跳过", p.getPhone());
                return;
            }

            UserInfoDTO userInfoDTO = userInfoDTOS.getList().get(0);
            if (StringUtils.isBlank(userInfoDTO.getUserId())) {
                return;
            }

            // 是否有激活次数
            if (Objects.nonNull(userInfoDTO.getTotalOpenNum())) {
                log.info("手机号: {} 用户: {} 已激活 激活码格式: {} ", p.getPhone(), userInfoDTO.getUserId(), userInfoDTO.getTotalOpenNum());
                // 是否500个激活码
                if (userInfoDTO.getTotalOpenNum() < 500) {
                    log.info("手机号: {} 用户: {} 增加500个激活码", p.getPhone(), userInfoDTO.getUserId());
                    // 500个以下，进行增加激活码
                    AddTimesParam addTimesParam = new AddTimesParam();
                    addTimesParam.setUserId(Long.parseLong(userInfoDTO.getUserId()));
                    addTimesParam.setTimes(500);
                    userVipIntegrationService.addNum(addTimesParam);
                }
            } else {
                log.info("手机号: {} 用户: {} 增加激活vip信息", p.getPhone(), userInfoDTO.getUserId());
                // 不是vip 手动激活vip
                ImportResultDTO resultDTO = userVipIntegrationService.manualActiveVip(p.getPhone());
                // 激活失败 退回 等待下一次激活
                if (!Objects.equals(resultDTO.getSuccess(), Boolean.TRUE)) {
                    return;
                }
            }

            // 已激活 更新缓存信息
            BatchActiveDTO activeDTO = new BatchActiveDTO();
            activeDTO.setPhone(p.getPhone());
            activeDTO.setHasActived(1);
            activeDTO.setActiveTime(new Date());
            redisHashMapAdapter.put(VipCardRedisKey.BATCH_ACTIVE_PHONE, p.getPhone(), activeDTO);
        });

    }
}
