package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.AdminMenuMapper;
import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.service.security.AdminMenuService;
import com.bxm.localnews.admin.vo.AdminMenu;
import com.bxm.localnews.admin.vo.security.AdminMenuAdapterDTO;
import com.bxm.localnews.admin.vo.security.AdminMenuMeta;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author zhaoyadong 2018/10/15 20:28
 * @desc
 */
@Service("adminMenuService")
public class AdminMenuServiceImpl implements AdminMenuService {

    private AdminMenuMapper adminMenuMapper;

    @Autowired
    public AdminMenuServiceImpl(AdminMenuMapper adminMenuMapper) {
        this.adminMenuMapper = adminMenuMapper;
    }

    @Override
    public List<AdminMenuDTO> getMenusByRoleId(Integer roleId) {

        return this.adminMenuMapper.getMenusByRoleId(roleId);
    }

    @Override
    public List<AdminMenuAdapterDTO> getMenuAdapter(Integer roleId) {
        List<AdminMenuDTO> menuDTOS = getMenusByRole(Long.valueOf(roleId));

        if (null == menuDTOS) {
            return Lists.newArrayList();
        }

        return iterator(menuDTOS);
    }

    private List<AdminMenuAdapterDTO> iterator(List<AdminMenuDTO> menuDTOS) {
        List<AdminMenuAdapterDTO> result = Lists.newArrayList();

        for (AdminMenuDTO menuDTO : menuDTOS) {
            AdminMenuAdapterDTO adapterDTO = convert(menuDTO);
            adapterDTO.setChildren(childIterator(menuDTO.getChildren()));
            result.add(adapterDTO);
        }

        return result;
    }

    private List<AdminMenuAdapterDTO> childIterator(List<AdminMenu> childMenuDTOS) {
        if (null == childMenuDTOS) {
            return Lists.newArrayList();
        }

        List<AdminMenuAdapterDTO> result = Lists.newArrayList();
        for (AdminMenu menuDTO : childMenuDTOS) {
            AdminMenuAdapterDTO adapterDTO = convert(menuDTO);
            result.add(adapterDTO);
        }

        return result;
    }

    private AdminMenuAdapterDTO convert(AdminMenu menuDTO) {
        AdminMenuAdapterDTO adapterDTO = new AdminMenuAdapterDTO();

        AdminMenuMeta menuMeta = new AdminMenuMeta();
        menuMeta.setNoCache(Objects.equals(menuDTO.getCache(), 0));
        menuMeta.setIcon(menuDTO.getIcon());
        menuMeta.setTitle(menuDTO.getTitle());

        adapterDTO.setHidden(Objects.equals(menuDTO.getDisplay(), 0));
        adapterDTO.setComponent(menuDTO.getComponent());
        adapterDTO.setName(menuDTO.getName());
        adapterDTO.setPath(menuDTO.getPath());
        adapterDTO.setMeta(menuMeta);

        return adapterDTO;
    }

    @Override
    public List<AdminMenuDTO> getMenusByRole(Long roleId) {
        return this.adminMenuMapper.getMenusByRole(roleId);
    }

    @Override
    public List<AdminMenuDTO> getAllMenu() {
        return this.adminMenuMapper.getAllMenu();
    }

    @Override
    public AdminMenu selectByPrimaryKey(Integer menuId) {
        return this.adminMenuMapper.selectByPrimaryKey(menuId);
    }

    @Override
    public List<AdminMenu> getParentMenus() {
        return this.adminMenuMapper.getParentMenus();
    }

    @Override
    public int update(AdminMenu menu) {
        return this.adminMenuMapper.update(menu);
    }

    @Override
    public int insert(AdminMenu menu) {
        return adminMenuMapper.insert(menu);
    }

    @Override
    public int deleteByPrimaryKey(Integer menuid) {
        return this.adminMenuMapper.deleteByPrimaryKey(menuid);
    }

    @Override
    public List<MenuDTO> getMenusAndPermsByRoleId(Integer roleId) {
        return this.adminMenuMapper.getMenusAndPermsByRoleId(roleId);
    }
}
