package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.*;
import com.bxm.localnews.admin.domain.auth.UserRoleMapper;
import com.bxm.localnews.admin.dto.EquipmentDTO;
import com.bxm.localnews.admin.dto.MerchantMemberUserDTO;
import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.dto.security.UserVipDTO;
import com.bxm.localnews.admin.facade.MerchantFeignService;
import com.bxm.localnews.admin.integration.BizIntegrationService;
import com.bxm.localnews.admin.integration.MerchantMemberIntegrationService;
import com.bxm.localnews.admin.integration.UserEquityLevelMedalIntegrationService;
import com.bxm.localnews.admin.integration.UserIntegrationService;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.param.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.localnews.admin.param.security.UserPhoneParam;
import com.bxm.localnews.admin.service.medal.UserMedalManageService;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.MerchantUserVO;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserInviteHistoryBean;
import com.bxm.localnews.admin.vo.UserLoginHistory;
import com.bxm.localnews.admin.vo.auth.UserRoleBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Created by Administrator on 2017/12/19.
 */

@Service
public class AdminUserBaseInfoServiceImpl extends BaseService implements AdminUserBaseInfoService {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserBaseInfoServiceImpl.class);

    @Resource
    private UserMapper userBaseInfoMapper;

    @Resource
    private EquipmentInfoMapper equipmentInfoMapper;

    @Resource
    private BizIntegrationService bizIntegrationService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private UserRoleMapper userRoleMapper;

    @Autowired
    private MerchantFeignService merchantFeignService;

    @Resource
    private UserVipMapper userVipMapper;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private RecommendNativeMapper recommendNativeMapper;

    @Autowired
    private UserInviteHistoryMapper userInviteHistoryMapper;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private UserMedalManageService userMedalManageService;

    @Autowired
    private MerchantMemberIntegrationService merchantMemberIntegrationService;

    @Autowired
    private UserEquityLevelMedalIntegrationService userEquityLevelMedalIntegrationService;

    @Override
    public PageWarper<UserInfoDTO> queryUserInfoDTO(UserInfoParam param) {
        PageWarper<UserInfoDTO> pageWarper = null;
        //仅展示商家关联的用户
        Set<Long> relationMerchantUserIdSet;
        if (Objects.nonNull(param.getHasMerchantUser()) && param.getHasMerchantUser()) {
            relationMerchantUserIdSet = merchantMemberIntegrationService.getRelationMerchantUserId(param.getMerchantId());
            param.setRelationMerchantUserIdSet(relationMerchantUserIdSet);
        }
        if (null != param.getHasOpenCard()) {
            pageWarper = new PageWarper<>(this.userBaseInfoMapper.queryUserInfoListHasOpenVip(param));
        } else {
            pageWarper = new PageWarper<>(this.userBaseInfoMapper.queryUserInfoList(param));
        }
        if (!CollectionUtils.isEmpty(pageWarper.getList())) {
            List<Long> userIdList = Lists.newArrayList();
            pageWarper.getList().forEach(item -> userIdList.add(Long.valueOf(item.getUserId())));

            List<UserEquityLevelMedalInfoDTO> equityLevelMedalInfo = userEquityLevelMedalIntegrationService.getEquityLevelInfoList(userIdList);
            List<UserRoleBean> userRoles = userRoleMapper.queryUserRoles(userIdList);
            if (!userRoles.isEmpty()) {
                pageWarper.getList().forEach(user -> {
                    List<String> userRoleCodes = userRoles.stream().filter(userRole ->
                            userRole.getUserId().equals(Long.valueOf(user.getUserId())))
                            .map(UserRoleBean::getRoleCode).collect(Collectors.toList());

                    user.setRoles(userRoleCodes);
                });
            }
            if (!equityLevelMedalInfo.isEmpty()) {
                Map<Long, List<UserEquityLevelMedalInfoDTO>> equityLevelMap = equityLevelMedalInfo.stream().collect(Collectors.groupingBy(UserEquityLevelMedalInfoDTO::getUserId));
                pageWarper.getList().forEach(user -> {
                    List<UserEquityLevelMedalInfoDTO> userEquityLevelMedalInfoDTOS = equityLevelMap.get(Long.valueOf(user.getUserId()));
                    if (!userEquityLevelMedalInfoDTOS.isEmpty()) {
                        user.setUserLevel(userEquityLevelMedalInfoDTOS.get(0).getUserEquityDTO().getLevel());
                    }

                });
            }
            //补充：获取用户vip码剩余激活次数
            List<UserVipDTO> listUserVip = userVipMapper.getVipListByUserIds(userIdList);
            pageWarper.getList().forEach(userInfo -> {
                boolean hit = false;

                if (listUserVip.size() > 0) {
                    for (UserVipDTO vipEntity : listUserVip) {
                        if (String.valueOf(vipEntity.getUserId()).equals(userInfo.getUserId())) {
                            userInfo.setTotalOpenNum(vipEntity.getActiveTimes() + vipEntity.getMaxTimes());
                            userInfo.setLeftOpenNum(vipEntity.getMaxTimes());
                            hit = true;
                            break;
                        }
                    }
                }
                //设置用户勋章数量
                userInfo.setMedalNum(userMedalManageService.getUserMedalNum(Long.valueOf(userInfo.getUserId())));

                if (!hit) {
                    userInfo.setLeftOpenNum(0);
                    userInfo.setTotalOpenNum(0);
                }
            });

        }


        return pageWarper;
    }

    @Override
    public User selectByUserId(Long userId) {
        return this.userBaseInfoMapper.selectByUserId(userId);
    }

    @Override
    public boolean updateUserBlack(Map<String, Object> map) {
        return this.userBaseInfoMapper.updateUserBlack(map);
    }

    @Override
    public Boolean deleteUser(Long userId) {
        Long id = nextId();
        User user = selectByUserId(userId);

        if (null == user) {
            LOG.error("根据此userId:{}未查询到用户信息,删除用户失败", userId);
            return false;
        }
        //删除缓存
        redisStringAdapter.remove(RedisConfig.USER_INFO.copy().appendKey(userId));

        //三步删除用户数据库 一步删除redis缓存
        String weChat = user.getWeixin() == null ? null : user.getWeixin() + id;

        //更新用户为禁用,手机号、设备号置空,微信号特殊处理。
        userBaseInfoMapper.updateUser(userId, weChat);

        //更新vip邀请查看记录的微信号特殊处理
        userBaseInfoMapper.updateVipRecord(userId, weChat);
        if (StringUtils.isNotEmpty(user.getWeixin())) {
            userBaseInfoMapper.updateVipViewRecord(user.getWeixin(), weChat);
        }

        //删除设备
        UserLoginHistory userLoginHistory = userBaseInfoMapper.selectHistoryByUserId(userId);
        if (null != userLoginHistory && StringUtils.isNoneEmpty(userLoginHistory.getEquipment())) {
            EquipmentDTO equipmentDTO = bizIntegrationService.getDevice(userLoginHistory.getEquipment());
            if (null != equipmentDTO && StringUtils.isNoneEmpty(equipmentDTO.getId())) {
                //删除用户设备的对应表
                userBaseInfoMapper.deleteUserEquipment(user.getEquipment());
                //删除设备
                equipmentInfoMapper.deleteByPrimaryKey(equipmentDTO.getId());
            }
        }

        //删除本地人推荐库记录
        recommendNativeMapper.deleteByPrimaryKey(userId);

        //删除在授权登录认证表中信息
        userBaseInfoMapper.deleteUser(userId);

        //删除缓存
        clearUserCache(userId);

        // 删除vip信息
        redisHashMapAdapter.remove(RedisConfig.USER_VIP_INFO, String.valueOf(userId));
        redisHashMapAdapter.remove(RedisConfig.USER_VIP_CODE_LEFT_USE_NUM, String.valueOf(userId));
        userVipMapper.delete(userId);

        //更新收徒关系
        if (userInviteHistoryMapper.delete(userId) > 0) {
            UserInviteHistoryBean inviteHistoryBean = userInviteHistoryMapper.selectByUserId(userId);
            if (null != inviteHistoryBean) {
                List<Long> ids = new ArrayList<>();
                ids.add(inviteHistoryBean.getInviteUserId());
                ids.add(inviteHistoryBean.getInviteCreatedUserId());
                ids.add(inviteHistoryBean.getInviteSuperUserId());
                ids.add(inviteHistoryBean.getCreatedUserId());
                //邀请人的徒弟数量-1
                userBaseInfoMapper.decrInviteNum(ids);
                //删除用户缓存
                userIntegrationService.delUserCacheBatch(ids);
            }
        }

        //删除商家信息
        merchantFeignService.deleteMerchantInfoByUid(userId);
        return true;
    }

    private void clearUserCache(Long userId) {
        redisStringAdapter.remove(RedisConfig.USER_INFO.copy().appendKey(userId));
    }

    @Override
    public List<UserInfoDTO> getVirtualUserList() {
        return this.userBaseInfoMapper.getVirtualUserList();
    }

    @Override
    public Message modifyPhoneNo(UserPhoneParam param) {
        if (StringUtils.length(param.getPhone()) != 11 || !NumberUtils.isDigits(param.getPhone())) {
            return Message.build(false, "输入的不是一个有效的手机号码");
        }

        UserInfoDTO userInfoDTO = userBaseInfoMapper.queryByPhone(param.getPhone());

        if (userInfoDTO != null && Objects.equals(param.getUserId() + "", userInfoDTO.getUserId())) {
            return Message.build(false, "用户当前手机号码已经是该号码");
        }

        if (userInfoDTO != null) {
            return Message.build(false, "该号码已经绑定了用户，ID:[" + userInfoDTO.getUserId() + "],昵称:[" + userInfoDTO.getUserName() + "]");
        }

        Message message = Message.build(userBaseInfoMapper.updatePhone(param));

        if (message.isSuccess()) {
            clearUserCache(param.getUserId());
        }

        return message;
    }

    @Override
    public List<MerchantUserVO> queryMerchantUserList(String nickname) {
        List<MerchantMemberUserDTO> relationMerchantUserInfoList = merchantMemberIntegrationService.getRelationMerchantUserInfo();

        Set<Long> merchantUserIds = relationMerchantUserInfoList.stream().map(MerchantMemberUserDTO::getUserId).collect(Collectors.toSet());

        //可能会有重复的key出现，如果出现设置保存首次出现的值
        Map<Long, MerchantMemberUserDTO> userId2MerchantInfo = relationMerchantUserInfoList.stream()
                .collect(
                        Collectors.toMap(MerchantMemberUserDTO::getUserId, Function.identity(), (merchantMemberUserDtoOne, merchantMemberUserDtoTow) -> merchantMemberUserDtoOne
                        ));

        //判断查询类型,1:是一个字符串按照用户名方式去查询，2：是一个long类型，按照用户id的方式去查询
        int type = 1;
        if (isValidLong(nickname)) {
            type = 2;
        }
        List<MerchantUserVO> merchantUserResultList = userBaseInfoMapper.queryMerchantUserInfoList(merchantUserIds, nickname, type);

        for (MerchantUserVO merchantUserVO : merchantUserResultList) {
            MerchantMemberUserDTO merchantMemberUserDTO = userId2MerchantInfo.get(merchantUserVO.getUserId());
            merchantUserVO.setDescription(merchantUserVO.getNickname() + "-" + merchantUserVO.getUserId());
            merchantUserVO.setMerchantId(merchantMemberUserDTO.getMerchantId());
            merchantUserVO.setMerchantName(merchantMemberUserDTO.getMerchantName());
        }
        return merchantUserResultList;
    }

    /**
     * 判断输入的值是否是long类型
     *
     * @param str 输入字符串
     * @return 是否是long类型
     */
    private boolean isValidLong(String str) {
        try {
            long longValue = Long.parseLong(str);
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }
}
