package com.bxm.localnews.admin.service.user.impl;

import com.bxm.localnews.admin.dto.AccountCashFlowDTO;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.UserCashFlowParam;
import com.bxm.localnews.admin.service.user.UserAccountService;
import com.bxm.newidea.component.vo.PageWarper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2021/1/13 12:02
 */
@Service
@Slf4j
public class UserAccountServiceImpl implements UserAccountService {
    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;


    @Override
    public PageWarper<AccountCashFlowDTO> getCashFlow(UserCashFlowParam userCashFlowParam) {
        return userAccountIntegrationService.getCashFlow(userCashFlowParam.getUserId(),
                userCashFlowParam.getPageNum(), userCashFlowParam.getPageSize(), userCashFlowParam.getType());
    }

}
