package com.bxm.localnews.admin.timer.medal;

import com.bxm.localnews.admin.service.medal.MedalGrantManageService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/6 4:14 下午
 */
@Slf4j
@Component
public class CustomGrantTimer extends AbstractCronTask<String> {

    @Autowired
    private MedalGrantManageService medalGrantManageService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("==================发放定制勋章定时任务开启===================");
        medalGrantManageService.grantCustomMedal();
        log.info("==================发放成就勋章定时任务结束===================");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "发放定制勋章定时任务";
    }

    @Override
    public String cron() {
        // 1分钟执行一次
        return "0 0/1 * * * ? ";
    }
}