package com.bxm.localnews.admin.timer.medal;

import com.bxm.localnews.admin.service.medal.MedalManageService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/6 4:14 下午
 */
@Slf4j
@Component
public class CustomMedalExpiredTimer extends AbstractCronTask<String> {

    @Autowired
    private MedalManageService medalManageService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("==================下架过期定制勋章定时任务开启===================");
        medalManageService.offlineExpiredCustomMedal();
        log.info("==================下架过期定制勋章定时任务结束===================");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "下架过期定制勋章定时任务";
    }

    @Override
    public String cron() {
        //每天执行执行一次
        return "0 1 0 */1 * ? ";
    }
}