package com.bxm.localnews.admin.utils;

import com.bxm.localnews.admin.service.security.AdminUserService;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * 从网关层的响应结果中获取用户ID
 *
 * @author liujia
 * @date 2020-07-15 16:59
 **/
public class SecurityUtils {

    private SecurityUtils() {
    }

    public static AdminUser getLoginUser() {
        AdminUserService adminUserService = SpringContextHolder.getBean(AdminUserService.class);

        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();

        if (requestAttributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
            HttpServletRequest request = servletRequestAttributes.getRequest();

            String currentUserId = request.getHeader("currentUserId");

            if (NumberUtils.isDigits(currentUserId)) {
                return adminUserService.selectById(Long.valueOf(currentUserId));
            }
        }

        AdminUser user = new AdminUser();
        user.setId(0L);
        user.setName("匿名");
        return user;
    }

    public static Long currentUserId() {
        return getLoginUser().getId();
    }
}
