/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.component.office.excel.format.config.CellTypeEnum;
import com.bxm.component.office.excel.parse.ExcelParser;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import com.bxm.component.office.excel.parse.setting.ParseSetting;
import com.bxm.localnews.admin.domain.CommodityCodeMapper;
import com.bxm.localnews.admin.domain.CommodityMapper;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.enums.CommodityCategoryEnum;
import com.bxm.localnews.admin.param.CommodityParam;
import com.bxm.localnews.admin.param.CommodityQueryParam;
import com.bxm.localnews.admin.service.activity.CommodityService;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.admin.vo.CommodityCodeBean;
import com.bxm.localnews.admin.vo.CommodityCodeSet;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityServiceImpl
extends BaseService
implements CommodityService {
    private CommodityMapper commodityMapper;
    private CommodityCodeMapper commodityCodeMapper;
    private PrivilegeMapper privilegeMapper;

    @Autowired
    public CommodityServiceImpl(CommodityMapper commodityMapper, CommodityCodeMapper commodityCodeMapper, PrivilegeMapper privilegeMapper) {
        this.commodityMapper = commodityMapper;
        this.commodityCodeMapper = commodityCodeMapper;
        this.privilegeMapper = privilegeMapper;
    }

    @Override
    public PageWarper<CommodityBean> getCommodities(CommodityQueryParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        return new PageWarper(this.commodityMapper.queryByPageSize(param));
    }

    @Override
    public Message save(CommodityParam param) {
        CommodityBean entity = this.convert(param);
        entity.setId(this.nextId());
        entity.setAddTime(new Date());
        Message message = Message.build();
        List<CommodityCodeBean> commodityCodes = this.parseExcel(param);
        this.logger.debug("excel's info" + JSONObject.toJSONString(commodityCodes));
        if (commodityCodes.size() > 0 && entity.getNum() != commodityCodes.size() && !param.getCategory().equals(CommodityCategoryEnum.MOVIE.getType())) {
            message.setSuccess(false).setMessage("\u4e0a\u4f20\u7684\u5546\u54c1\u5151\u5956\u7801\u6587\u4ef6\u4e2d\u6570\u91cf[" + commodityCodes.size() + "]\u4e0e\u5546\u54c1\u5e93\u5b58\u6570\u91cf[" + entity.getNum() + "]\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u81f3\u4e24\u8005\u6570\u91cf\u4e00\u81f4");
            return message;
        }
        message = Message.build((int)this.commodityMapper.insert(entity));
        if (message.isSuccess()) {
            this.saveCommodityCodes(commodityCodes, entity.getId());
        }
        return message;
    }

    @Override
    public Message modify(CommodityParam param) {
        CommodityBean entity = this.convert(param);
        Message message = Message.build();
        List codes = this.commodityCodeMapper.getUsedCodes(entity.getId());
        List<CommodityCodeSet> usedCodesSetList = this.convert(codes);
        List usedCodes = codes.stream().filter(code -> code.getUsedFlag() == 1).collect(Collectors.toList());
        this.logger.debug("db's info:{}, db's used code:{}", JSONObject.toJSON(usedCodesSetList), JSONObject.toJSON(usedCodes));
        this.commodityCodeMapper.deleteByCommodityId(entity.getId());
        ArrayList commodityCodes = this.parseExcel(param);
        List<CommodityCodeSet> commodityCodesSetList = this.convert(commodityCodes);
        this.logger.debug("excel's info" + JSONObject.toJSONString(commodityCodesSetList));
        HashSet<CommodityCodeSet> finalCodeSet = new HashSet<CommodityCodeSet>();
        finalCodeSet.addAll(usedCodesSetList);
        finalCodeSet.addAll(commodityCodesSetList);
        this.logger.debug("merge's info" + JSONObject.toJSONString(commodityCodesSetList));
        if (commodityCodes.size() > 0 && finalCodeSet.size() != commodityCodes.size() && !param.getCategory().equals(CommodityCategoryEnum.MOVIE.getType())) {
            message.setSuccess(false).setMessage("\u4e0a\u4f20\u7684\u5546\u54c1\u5151\u5956\u7801\u6587\u4ef6\u4e2d\u6570\u91cf[" + commodityCodes.size() + "]\u4e0e\u5546\u54c1\u5e93\u5b58\u6570\u91cf[" + finalCodeSet.size() + "]\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u81f3\u4e24\u8005\u6570\u91cf\u4e00\u81f4");
            return message;
        }
        commodityCodes = Lists.newArrayList();
        for (CommodityCodeSet commodityCodeSet : finalCodeSet) {
            CommodityCodeBean commodityCode = new CommodityCodeBean();
            commodityCode.setId(Long.valueOf(this.nextId()));
            commodityCode.setCode(commodityCodeSet.getCode());
            commodityCode.setExpireTime(commodityCodeSet.getExpireTime());
            boolean used = usedCodes.stream().anyMatch(usedCode -> StringUtils.equals((CharSequence)usedCode.getCode(), (CharSequence)commodityCodeSet.getCode()));
            commodityCode.setUsedFlag(used ? 1 : 0);
            commodityCodes.add(commodityCode);
        }
        message = Message.build((int)this.commodityMapper.updateByPrimaryKey(entity));
        if (message.isSuccess()) {
            this.saveCommodityCodes(commodityCodes, entity.getId());
        }
        return Message.build((boolean)true);
    }

    private List<CommodityCodeSet> convert(List<CommodityCodeBean> commodityCodeBeanList) {
        return commodityCodeBeanList.stream().map(commodityCodeBean -> {
            CommodityCodeSet commodityCodeSet = new CommodityCodeSet();
            commodityCodeSet.setCode(commodityCodeBean.getCode());
            commodityCodeSet.setExpireTime(commodityCodeBean.getExpireTime());
            return commodityCodeSet;
        }).collect(Collectors.toList());
    }

    private void saveCommodityCodes(List<CommodityCodeBean> commodityCodes, final Long commodityId) {
        if (commodityCodes.size() > 0) {
            new BatchHelper<CommodityCodeMapper, CommodityCodeBean>(CommodityCodeMapper.class, commodityCodes, "primarySessionTemplate"){

                protected int invoke(CommodityCodeBean element) {
                    element.setId(Long.valueOf(CommodityServiceImpl.this.nextId()));
                    element.setCommodityId(commodityId);
                    return ((CommodityCodeMapper)this.mapper).insert(element);
                }
            };
        }
    }

    private CommodityBean convert(CommodityParam param) {
        Preconditions.checkArgument((param.getMechantId() > 0L ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u5fc5\u987b\u6709\u503c");
        CommodityBean entity = new CommodityBean();
        BeanUtils.copyProperties((Object)param, (Object)entity);
        if (null == entity.getCurrentPrice()) {
            entity.setCurrentPrice(BigDecimal.ZERO);
        }
        if (null == entity.getOriginalCost()) {
            entity.setOriginalCost(BigDecimal.ZERO);
        }
        return entity;
    }

    private List<CommodityCodeBean> parseExcel(CommodityParam param) {
        this.logger.debug("\u6536\u5230\u5546\u54c1\u7f16\u7801excel[{}]", (Object)param.getCodeExcel());
        List result = Lists.newArrayList();
        if (null != param.getCodeExcel()) {
            ExcelParser excelParser = (ExcelParser)SpringContextHolder.getBean(ExcelParser.class);
            ParseSetting setting = new ParseSetting();
            setting.setEntityClasz(CommodityCodeBean.class);
            setting.addHead(new ParseHeader("\u5546\u54c1\u7f16\u7801", "code"));
            setting.addHead(new ParseHeader("\u8fc7\u671f\u65f6\u95f4", "expireTime", CellTypeEnum.DATE));
            try {
                result = excelParser.parse(param.getCodeExcel().getInputStream(), setting);
            }
            catch (IOException e) {
                this.logger.error("\u89e3\u6790excel\u5f02\u5e38\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a[{}]", (Object)param);
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public CommodityBean get(long id) {
        return this.commodityMapper.selectByPrimaryKey(Long.valueOf(id));
    }

    @Override
    public Message change(long id, int status) {
        return Message.build((int)this.commodityMapper.updateStatus(id, status));
    }

    @Override
    public Message remove(long id) {
        int relation = this.privilegeMapper.getRelationPrivilegeByCommodity(id);
        if (relation > 0) {
            return Message.build((boolean)false).setMessage("\u5546\u54c1\u6709" + relation + "\u4e2a\u5173\u8054\u7684\u6d3b\u52a8\uff0c\u8bf7\u5148\u5173\u95ed\u5bf9\u5e94\u7684\u6d3b\u52a8");
        }
        return Message.build((int)this.commodityMapper.deleteByPrimaryKey(Long.valueOf(id)));
    }

    @Override
    public List<CommodityBean> getTopMatchCommodities(String keyword) {
        return this.commodityMapper.queryTopMatch(keyword);
    }

    @Override
    public Message execStoreDeduction(long commodityId, int num, final long privilegeId) {
        List commodityCodeBeans;
        Preconditions.checkArgument((commodityId > 0L ? 1 : 0) != 0, (Object)"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u5546\u54c1ID");
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0, (Object)"\u6263\u9664\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        Message message = Message.build();
        int lastNum = this.commodityMapper.getStoreNum(commodityId, num);
        if (lastNum >= 0) {
            message = Message.build((int)this.commodityMapper.updateStoreNum(commodityId, -num));
        } else {
            message.setSuccess(false).setMessage("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u8fdb\u884c\u9884\u51fa\u5e93\u64cd\u4f5c");
        }
        if (message.isSuccess() && (commodityCodeBeans = this.commodityCodeMapper.getUnusedCommodities(commodityId, num)).size() > 0) {
            new BatchHelper<CommodityCodeMapper, CommodityCodeBean>(CommodityCodeMapper.class, (Collection)commodityCodeBeans, "primarySessionTemplate"){

                protected int invoke(CommodityCodeBean element) {
                    element.setUsedFlag(1);
                    element.setPrivilegeId(Long.valueOf(privilegeId));
                    return ((CommodityCodeMapper)this.mapper).updateByPrimaryKey(element);
                }
            };
        }
        return message;
    }

    @Override
    public Message execStoreReturned(long commodityId, int num, long privilegeId) {
        List commodityCodeBeans;
        Preconditions.checkArgument((commodityId > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0, (Object)"\u9000\u56de\u7684\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        Message message = Message.build((int)this.commodityMapper.updateStoreNum(commodityId, num));
        if (message.isSuccess() && (commodityCodeBeans = this.commodityCodeMapper.getUseCommoditiesAndPrivilege(commodityId, num, privilegeId)).size() > 0) {
            new BatchHelper<CommodityCodeMapper, CommodityCodeBean>(CommodityCodeMapper.class, (Collection)commodityCodeBeans, "primarySessionTemplate"){

                protected int invoke(CommodityCodeBean element) {
                    element.setUsedFlag(0);
                    element.setPrivilegeId(null);
                    return ((CommodityCodeMapper)this.mapper).updateByPrimaryKey(element);
                }
            };
        }
        return message;
    }
}

