/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.admin.common.DingtalkProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.SendFlowConvert;
import com.bxm.localnews.admin.domain.GoldFlowMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.FolwerDTO;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.AccountGoldParam;
import com.bxm.localnews.admin.param.BaseFlowerParam;
import com.bxm.localnews.admin.param.FlowerParam;
import com.bxm.localnews.admin.service.activity.GiveOutFlowerService;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiveOutFlowerServiceImpl
extends BaseService
implements GiveOutFlowerService {
    private final SendFlowConvert sendFlowConvert;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final UserMapper userMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final HttpClientService httpClientService;
    private final DingtalkProperties dingtalkProperties;
    private final GoldFlowMapper goldFlowMapper;
    private final MessageSender messageSender;

    @Autowired
    public GiveOutFlowerServiceImpl(SendFlowConvert sendFlowConvert, UserAccountIntegrationService userAccountIntegrationService, UserMapper userMapper, RedisStringAdapter redisStringAdapter, HttpClientService httpClientService, DingtalkProperties dingtalkProperties, GoldFlowMapper goldFlowMapper, MessageSender messageSender) {
        this.sendFlowConvert = sendFlowConvert;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.userMapper = userMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.httpClientService = httpClientService;
        this.dingtalkProperties = dingtalkProperties;
        this.goldFlowMapper = goldFlowMapper;
        this.messageSender = messageSender;
    }

    @Override
    public Long getUniquelyId() {
        return this.nextId();
    }

    @Override
    public FolwerDTO doSendFolwer(FlowerParam flowerParam, AdminUser adminUser) {
        FolwerDTO result = new FolwerDTO();
        List<BaseFlowerParam.UserFlower> userFlowers = this.sendFlowConvert.convert(flowerParam);
        List<Long> notExitIds = this.checkUserExits(userFlowers);
        if (CollectionUtils.isNotEmpty(notExitIds)) {
            result.setSuccessCode(Integer.valueOf(1));
            result.setNotExitIds(notExitIds);
        } else {
            result = this.caculateFlower(userFlowers, flowerParam, result, adminUser);
        }
        return result;
    }

    private FolwerDTO caculateFlower(List<BaseFlowerParam.UserFlower> userFlowers, FlowerParam flowerParam, FolwerDTO result, AdminUser adminUser) {
        int folwerNum = userFlowers.stream().mapToInt(BaseFlowerParam.UserFlower::getFlowerNum).sum();
        if (folwerNum < 1000) {
            this.sendflower(userFlowers, flowerParam, result, adminUser);
        } else {
            String verifyCode = this.redisStringAdapter.getString(this.getVerifyCodeKey(flowerParam));
            if (StringUtils.isNotBlank((CharSequence)verifyCode)) {
                if (StringUtils.isNotBlank((CharSequence)flowerParam.getVerifyCode())) {
                    if (verifyCode.equalsIgnoreCase(flowerParam.getVerifyCode())) {
                        this.sendflower(userFlowers, flowerParam, result, adminUser);
                        this.redisStringAdapter.remove(this.getVerifyCodeKey(flowerParam));
                    } else {
                        result.setSuccessCode(Integer.valueOf(3));
                    }
                } else {
                    result.setSuccessCode(Integer.valueOf(2));
                }
            } else {
                this.sendVerifyCode(flowerParam, folwerNum, userFlowers.size());
                result.setSuccessCode(Integer.valueOf(2));
            }
        }
        return result;
    }

    private void sendVerifyCode(FlowerParam flowerParam, int folwerNum, int peopleNum) {
        String verifyCode = RandomStringUtils.random((int)4, (boolean)false, (boolean)true);
        StringBuilder content = new StringBuilder();
        content.append("\u3010\u7ea2\u82b1\u53d1\u653e\u9a8c\u8bc1\u7801:").append(verifyCode).append(",\u603b\u8ba1").append(folwerNum).append("\u7ea2\u82b1, \u5171").append(peopleNum).append("\u4eba ").append("\uff0c\u5907\u6ce8\uff1a").append(flowerParam.getReason()).append("\u3011");
        JSONObject text = new JSONObject();
        text.put("content", (Object)content);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        String response = this.httpClientService.doPostJson(this.dingtalkProperties.getVerifyCodeWebhook(), msg.toJSONString());
        this.logger.debug("dingding response:{}", (Object)response);
        this.redisStringAdapter.set(this.getVerifyCodeKey(flowerParam), (Object)verifyCode, 900L);
    }

    private KeyGenerator getVerifyCodeKey(FlowerParam flowerParam) {
        KeyGenerator flowerKey = RedisConfig.CACULATE_FLOWER.copy();
        BaseFlowerParam param = new BaseFlowerParam();
        BeanUtils.copyProperties((Object)flowerParam, (Object)param);
        int code = param.hashCode();
        KeyGenerator keyGenerator = flowerKey.appendKey((Object)code);
        return keyGenerator;
    }

    private List<Long> checkUserExits(List<BaseFlowerParam.UserFlower> userFlowers) {
        ArrayList result = Lists.newArrayList();
        userFlowers.forEach(e -> {
            User user = this.userMapper.selectByUserId(e.getUserId().longValue());
            if (Objects.isNull(user) || user.getState() != 1) {
                result.add(e.getUserId());
            }
        });
        return result;
    }

    private void sendflower(List<BaseFlowerParam.UserFlower> userFlowers, FlowerParam flowerParam, FolwerDTO result, AdminUser adminUser) {
        String reason = StringUtils.isNotBlank((CharSequence)flowerParam.getReason()) ? flowerParam.getReason() + "," + adminUser.getName() : adminUser.getName();
        String url = "wst://mine/flowerRecord?index=0";
        userFlowers.stream().forEach(e -> {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(e.getUserId());
            param.setGold(e.getFlowerNum());
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("ACTIVITY_GIVEOUT");
            param.setAddTotal(Boolean.valueOf(true));
            param.setRelationId(flowerParam.getId());
            param.setReason(reason);
            this.userAccountIntegrationService.addGold(param);
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
            info.addExtend("msgId", (Object)this.nextId());
            info.addExtend("url", (Object)url);
            PushMessage message = PushMessage.build();
            message.setTitle("\u53d1\u653e\u5956\u52b1");
            message.setContent(flowerParam.getCopyWrite());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)e.getUserId()));
            message.setPayloadInfo(info);
            this.messageSender.sendPushMessage(message);
        });
        result.setSuccessCode(Integer.valueOf(0));
    }

    @Override
    public PageWarper<GoldFlow> listFlower(PageParam pageParam) {
        return new PageWarper(this.goldFlowMapper.giveOutFlowerList(pageParam));
    }
}

