/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.domain.RedPacketApprovalHistoryMapper;
import com.bxm.localnews.admin.domain.RedPacketMapper;
import com.bxm.localnews.admin.dto.RedPacketDTO;
import com.bxm.localnews.admin.enums.ApproveRedPacketEnum;
import com.bxm.localnews.admin.enums.RedPacketOnlineStatusEnum;
import com.bxm.localnews.admin.integration.PushMsgIntegService;
import com.bxm.localnews.admin.param.RedPacketParam;
import com.bxm.localnews.admin.service.activity.RedPacketService;
import com.bxm.localnews.admin.vo.RedPacket;
import com.bxm.localnews.admin.vo.RedPacketApprovalHistory;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketServiceImpl
implements RedPacketService {
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketServiceImpl.class);
    private RedPacketMapper redPacketMapper;
    private RedPacketApprovalHistoryMapper redPacketApprovalHistoryMapper;
    private SequenceCreater sequenceCreater;
    private PushMsgIntegService pushMsgIntegService;

    @Autowired
    public RedPacketServiceImpl(RedPacketMapper redPacketMapper, RedPacketApprovalHistoryMapper redPacketApprovalHistoryMapper, SequenceCreater sequenceCreater, PushMsgIntegService pushMsgIntegService) {
        this.redPacketMapper = redPacketMapper;
        this.redPacketApprovalHistoryMapper = redPacketApprovalHistoryMapper;
        this.sequenceCreater = sequenceCreater;
        this.pushMsgIntegService = pushMsgIntegService;
    }

    @Override
    public PageWarper<RedPacketDTO> queryList(RedPacketParam redPacketParam) {
        RedPacket redPacketEntity = new RedPacket();
        BeanUtils.copyProperties((Object)redPacketParam, (Object)redPacketEntity);
        PageWarper queryResultPage = new PageWarper(this.redPacketMapper.queryList(redPacketEntity));
        if (CollectionUtils.isEmpty((Collection)queryResultPage.getList())) {
            LOG.info("\u67e5\u8be2\u7ea2\u5305\u6570\u636e\u5217\u8868\u4e3a\u7a7a,\u67e5\u8be2\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)redPacketEntity));
            return queryResultPage;
        }
        queryResultPage.getList().forEach(redPacketDTO -> {
            BigDecimal receivedAmount = redPacketDTO.getAmount().subtract(redPacketDTO.getSurplusAmount());
            receivedAmount.setScale(2, 1);
            redPacketDTO.setReceivedAmount(receivedAmount);
        });
        return new PageWarper(this.redPacketMapper.queryList(redPacketEntity));
    }

    @Override
    public boolean approvalRedPacket(Long id, Integer approvalStatus, String approvalContent) {
        RedPacket redPacketEntity = new RedPacket();
        redPacketEntity.setId(id);
        redPacketEntity.setModifyTime(new Date());
        redPacketEntity.setApprovalTime(new Date());
        if (ApproveRedPacketEnum.OK.getApprovalCode().equals(approvalStatus)) {
            this.saveApprovalHistory(id, ApproveRedPacketEnum.OK.getApprovalCode(), null);
            redPacketEntity.setActiveStatus(ApproveRedPacketEnum.OK.getApprovalCode());
            redPacketEntity.setOnlineStatus(RedPacketOnlineStatusEnum.ON_LINE.getStatus());
            if (this.updateSucBySingle(this.redPacketMapper.approvalRedPacket(redPacketEntity))) {
                this.pushApprovalOKResult(id);
                return true;
            }
            return false;
        }
        if (ApproveRedPacketEnum.REJECT.getApprovalCode().equals(approvalStatus)) {
            this.saveApprovalHistory(id, ApproveRedPacketEnum.REJECT.getApprovalCode(), approvalContent);
            redPacketEntity.setActiveStatus(ApproveRedPacketEnum.REJECT.getApprovalCode());
            redPacketEntity.setComment(approvalContent);
            if (this.updateSucBySingle(this.redPacketMapper.approvalRedPacket(redPacketEntity))) {
                this.pushApprovalRejectResult(id);
                return true;
            }
            return false;
        }
        LOG.error("\u9519\u8bef\u72b6\u6001,\u4e0d\u5ba1\u6838,\u7ea2\u5305id\u4e3a:{}, \u5ba1\u6838\u72b6\u6001\u4e3a:{}", (Object)id, (Object)approvalStatus);
        return false;
    }

    @Override
    public boolean updateOnlineStatus(Long id, Integer onlineStatus) {
        RedPacket redPacketEntity = new RedPacket();
        redPacketEntity.setId(id);
        redPacketEntity.setOnlineStatus(onlineStatus);
        redPacketEntity.setModifyTime(new Date());
        return this.updateSucBySingle(this.redPacketMapper.updateByPrimaryKeySelective(redPacketEntity));
    }

    @Override
    public RedPacketDTO getRedPacketDetail(Long id) {
        RedPacket redPacket = this.redPacketMapper.selectByPrimaryKey(id);
        if (null == redPacket) {
            LOG.error("\u7ea2\u5305id:{}\u67e5\u8be2\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a", (Object)id);
            return null;
        }
        LOG.info("\u7ea2\u5305id:{}\u67e5\u8be2\u8be6\u60c5\u7ed3\u679c\u4e3a:{}", (Object)id, (Object)JSON.toJSONString((Object)redPacket));
        RedPacketDTO redPacketDTO = new RedPacketDTO();
        BeanUtils.copyProperties((Object)redPacket, (Object)redPacketDTO);
        return redPacketDTO;
    }

    @Override
    public boolean editRedPacket(RedPacketParam redPacketParam) {
        RedPacket redPacketEntity = new RedPacket();
        redPacketEntity.setId(redPacketParam.getId());
        redPacketEntity.setContent(redPacketParam.getContent());
        redPacketEntity.setPromotionContent(redPacketParam.getPromotionContent());
        redPacketEntity.setPromotionImg(redPacketParam.getPromotionImg());
        redPacketEntity.setModifyTime(new Date());
        return this.updateSucBySingle(this.redPacketMapper.updateByPrimaryKeySelective(redPacketEntity));
    }

    private boolean pushApprovalOKResult(Long redPacketId) {
        RedPacket redPacket = this.redPacketMapper.selectByPrimaryKey(redPacketId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.RED_PACKET_PASS);
        String content = "\ud83d\udc4d\u606d\u559c\u54e6\uff0c\u60a8\u7684\u53e3\u4ee4\u7ea2\u5305\u751f\u6548\u4e86\u54df\uff0c \u5feb\u6765\u5206\u4eab\u7ed9\u597d\u53cb\u5427>";
        Long msgId = this.sequenceCreater.nextLongId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("rpId", (Object)redPacketId);
        info.addExtend("userId", (Object)redPacket.getUserId());
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle("");
        pushMessage.setContent(content);
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)redPacket.getUserId()));
        pushMessage.setPayloadInfo(info);
        this.pushMsgIntegService.pushMsg(pushMessage);
        return true;
    }

    private boolean pushApprovalRejectResult(Long redPacketId) {
        RedPacket redPacket = this.redPacketMapper.selectByPrimaryKey(redPacketId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.RED_PACKET_NOT_PASS);
        String content = "\ud83d\ude05\u5f88\u9057\u61be\u54e6\uff0c\u60a8\u53d1\u7684\u53e3\u4ee4\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u5feb\u6765\u4fee\u6539\u4e0b\u5427>";
        Long msgId = this.sequenceCreater.nextLongId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("userId", (Object)redPacket.getUserId());
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setTitle("");
        pushMessage.setContent(content);
        pushMessage.setType(TemplateTypeEnum.NOTIFCTION);
        pushMessage.setPushReceiveScope(PushReceiveScope.pushSignle((Long)redPacket.getUserId()));
        pushMessage.setPayloadInfo(info);
        this.pushMsgIntegService.pushMsg(pushMessage);
        return true;
    }

    private void saveApprovalHistory(Long redPacketId, Integer approvalStatus, String comment) {
        RedPacketApprovalHistory redPacketApprovalHistoryEntity = new RedPacketApprovalHistory();
        redPacketApprovalHistoryEntity.setId(this.sequenceCreater.nextLongId());
        redPacketApprovalHistoryEntity.setRpId(redPacketId);
        redPacketApprovalHistoryEntity.setCreateTime(new Date());
        redPacketApprovalHistoryEntity.setStatus(approvalStatus);
        redPacketApprovalHistoryEntity.setComment(comment);
        LOG.info("\u7ea2\u5305\u5ba1\u6838\u5f55\u5165\u5ba1\u6838\u8bb0\u5f55\u8868,\u7ea2\u5305id\u4e3a:{}, \u5ba1\u6838\u72b6\u6001\u4e3a:{}", (Object)redPacketId, (Object)approvalStatus);
        this.redPacketApprovalHistoryMapper.insertSelective(redPacketApprovalHistoryEntity);
    }

    private boolean updateSucBySingle(int updateResult) {
        return 1 == updateResult;
    }
}

