/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.VoteChoiceCountMapper;
import com.bxm.localnews.admin.domain.VoteMapper;
import com.bxm.localnews.admin.domain.VoteOptionsMapper;
import com.bxm.localnews.admin.param.VoteQueryParam;
import com.bxm.localnews.admin.service.activity.VoteService;
import com.bxm.localnews.admin.utils.SecurityUtils;
import com.bxm.localnews.admin.vo.VoteBean;
import com.bxm.localnews.admin.vo.VoteChoiceCountBean;
import com.bxm.localnews.admin.vo.VoteOptionsBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class VoteServiceImpl
extends BaseService
implements VoteService {
    private final VoteMapper voteMapper;
    private final VoteOptionsMapper voteOptionsMapper;
    private final SqlSessionTemplate sqlSessionTemplate;
    private final RedisStringAdapter redisStringAdapter;
    private final VoteChoiceCountMapper voteChoiceCountMapper;

    @Autowired
    public VoteServiceImpl(VoteMapper voteMapper, VoteOptionsMapper voteOptionsMapper, @Qualifier(value="primarySessionTemplate") SqlSessionTemplate sqlSessionTemplate, RedisStringAdapter redisStringAdapter, VoteChoiceCountMapper voteChoiceCountMapper) {
        this.voteMapper = voteMapper;
        this.voteOptionsMapper = voteOptionsMapper;
        this.sqlSessionTemplate = sqlSessionTemplate;
        this.redisStringAdapter = redisStringAdapter;
        this.voteChoiceCountMapper = voteChoiceCountMapper;
    }

    @Override
    public VoteBean get(Long voteId) {
        Preconditions.checkArgument((null != voteId ? 1 : 0) != 0);
        VoteBean entity = this.voteMapper.selectByPrimaryKey(voteId);
        entity.setOptions(this.voteOptionsMapper.queryByVoteId(voteId));
        return entity;
    }

    @Override
    public PageWarper<VoteBean> getVoteByPage(VoteQueryParam param) {
        return new PageWarper(this.voteMapper.queryByPage(param));
    }

    @Override
    public List<VoteBean> getEnableVotes() {
        return this.voteMapper.selectEnableList();
    }

    @Override
    public Message remove(Long voteId) {
        Preconditions.checkArgument((null != voteId ? 1 : 0) != 0);
        VoteBean entity = new VoteBean();
        entity.setId(voteId);
        entity.setDeleteFlag(Byte.valueOf((byte)1));
        entity.setDeleteTime(new Date());
        entity.setDeleteUserId(SecurityUtils.currentUserId());
        return Message.build((int)this.voteMapper.remove(entity));
    }

    @Override
    public Message save(VoteBean entity) {
        Message message;
        this.fillLayoutType(entity);
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setId(Long.valueOf(this.nextId()));
            entity.setCreateTime(new Date());
            entity.setDeleteFlag(Byte.valueOf((byte)0));
            entity.setCreator(SecurityUtils.currentUserId());
            message = Message.build((int)this.voteMapper.insert(entity));
        } else {
            message = Message.build((int)this.voteMapper.updateByPrimaryKey(entity));
        }
        this.saveOptions(entity.getOptions(), entity.getId());
        this.clearCache(entity.getId());
        return message;
    }

    private void clearCache(Long voteId) {
        KeyGenerator key = RedisConfig.VOTE_OPTIONS_KEY.copy().appendKey((Object)voteId);
        this.redisStringAdapter.remove(key);
        key = RedisConfig.VOTE_INFO_KEY.copy().appendKey((Object)voteId);
        this.redisStringAdapter.remove(key);
    }

    private void saveOptions(List<VoteOptionsBean> requestOptions, Long voteId) {
        List existsOptions = this.voteOptionsMapper.queryByVoteId(voteId);
        ArrayList addOptions = Lists.newArrayList();
        ArrayList modifyOptions = Lists.newArrayList();
        ArrayList removeOptions = Lists.newArrayList();
        ArrayList newChoiceOptions = Lists.newArrayList();
        List existsChoiceList = this.voteChoiceCountMapper.selectByParam(voteId.longValue());
        int index = 0;
        for (VoteOptionsBean option : requestOptions) {
            option.setOrder(Integer.valueOf(++index));
            option.setDeleteFlag(Byte.valueOf((byte)0));
            option.setVoteId(voteId);
            if (null == option.getId() || option.getId() == 0L) {
                option.setId(Long.valueOf(this.nextId()));
                addOptions.add(option);
                newChoiceOptions.add(VoteChoiceCountBean.builder().id(Long.valueOf(this.nextId())).optionId(option.getId()).voteId(voteId).total(Integer.valueOf(0)).build());
                continue;
            }
            if (!existsOptions.stream().anyMatch(item -> option.getId().equals(item.getId()))) continue;
            modifyOptions.add(option);
            VoteChoiceCountBean existOptionCount = existsChoiceList.stream().filter(item -> option.getId().equals(item.getOptionId())).findFirst().orElse(VoteChoiceCountBean.builder().total(Integer.valueOf(0)).build());
            newChoiceOptions.add(VoteChoiceCountBean.builder().id(Long.valueOf(this.nextId())).optionId(option.getId()).voteId(voteId).total(existOptionCount.getTotal()).build());
        }
        for (VoteOptionsBean existsOption : existsOptions) {
            if (!requestOptions.stream().noneMatch(item -> existsOption.getId().equals(item.getId()))) continue;
            existsOption.setDeleteFlag(Byte.valueOf((byte)1));
            existsOption.setDeleteTime(new Date());
            existsOption.setDeleteUserId(SecurityUtils.currentUserId());
            removeOptions.add(existsOption);
        }
        if (addOptions.size() > 0) {
            MybatisBatchBuilder.create(VoteOptionsMapper.class, (Collection)addOptions).sessionTemplate(this.sqlSessionTemplate).run(VoteOptionsMapper::insert);
        }
        if (modifyOptions.size() > 0) {
            MybatisBatchBuilder.create(VoteOptionsMapper.class, (Collection)modifyOptions).sessionTemplate(this.sqlSessionTemplate).run(VoteOptionsMapper::updateByPrimaryKey);
        }
        if (removeOptions.size() > 0) {
            MybatisBatchBuilder.create(VoteOptionsMapper.class, (Collection)removeOptions).sessionTemplate(this.sqlSessionTemplate).run(VoteOptionsMapper::removeOption);
        }
        this.voteChoiceCountMapper.deleteByVoteId(voteId.longValue());
        if (newChoiceOptions.size() > 0) {
            MybatisBatchBuilder.create(VoteChoiceCountMapper.class, (Collection)newChoiceOptions).sessionTemplate(this.sqlSessionTemplate).run(VoteChoiceCountMapper::insert);
        }
    }

    private void fillLayoutType(VoteBean entity) {
        String layoutType = "IMG";
        List options = entity.getOptions();
        for (VoteOptionsBean option : options) {
            if (!StringUtils.isBlank((CharSequence)option.getImgUrl())) continue;
            layoutType = "TEXT";
            break;
        }
        entity.setLayoutType(layoutType);
    }
}

