/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.strategy;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.admin.common.AdminBizConfigProperties;
import com.bxm.localnews.admin.common.BizConfigProperties;
import com.bxm.localnews.admin.domain.CommodityCodeMapper;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.domain.WinnerMapper;
import com.bxm.localnews.admin.enums.PrivilegeStatusEnum;
import com.bxm.localnews.admin.integration.PushMsgIntegService;
import com.bxm.localnews.admin.service.SmsIntegService;
import com.bxm.localnews.admin.service.activity.CommodityService;
import com.bxm.localnews.admin.service.activity.strategy.DrawStrategyService;
import com.bxm.localnews.admin.service.base.ShortLinkService;
import com.bxm.localnews.admin.vo.CommodityCodeBean;
import com.bxm.localnews.admin.vo.ParticipantBean;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.localnews.admin.vo.WinnerBean;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDrawStrategyService
extends BaseService
implements DrawStrategyService {
    @Autowired
    private PrivilegeMapper privilegeMapper;
    @Autowired
    private CommodityCodeMapper commodityCodeMapper;
    @Autowired
    private WinnerMapper winnerMapper;
    @Autowired
    private AdminBizConfigProperties adminBizConfigProperties;
    @Autowired
    private BizConfigProperties bizConfigProperties;
    @Autowired
    private ShortLinkService shortLinkService;
    @Autowired
    private CommodityService commodityService;
    @Autowired
    private PushMsgIntegService pushMsgIntegService;
    @Autowired
    private SmsIntegService smsIntegService;

    @Override
    public Message execDraw(PrivilegeBean privilege) {
        if (privilege.getStatus() == PrivilegeStatusEnum.BEGIN.getCode()) {
            Message message = this.draw(privilege);
            if (message.isSuccess()) {
                this.privilegeMapper.changeStatusAndActualNum(privilege.getId(), PrivilegeStatusEnum.FINISH.getCode(), privilege.getActualNum());
            }
            return message;
        }
        return Message.build((boolean)false).setMessage("\u6d3b\u52a8[" + privilege.getId() + "]\u72b6\u6001\u4e0d\u662f\u8fdb\u884c\u4e2d\uff0c\u4e0d\u8fdb\u884c\u5904\u7406");
    }

    abstract Message draw(PrivilegeBean var1);

    void saveWinner(PrivilegeBean privilege, Set<Long> winnerSet, List<ParticipantBean> relationWinners, List<ParticipantBean> participants) {
        if (winnerSet == null || winnerSet.size() == 0) {
            this.commodityService.execStoreReturned(privilege.getCommodityId(), privilege.getPrizeNum(), privilege.getId());
            return;
        }
        ArrayList winners = Lists.newArrayList();
        List prizeList = this.commodityCodeMapper.getUnusedCommodities(privilege.getCommodityId(), winnerSet.size());
        int prizeCount = prizeList.size();
        if (prizeCount > 0 && winnerSet.size() != prizeCount) {
            this.logger.error("\u5956\u54c1\u6570\u91cf\u4e0d\u8db3\u4ee5\u53d1\u653e\u5956\u54c1\uff0c\u5b58\u5728\u4e1a\u52a1\u903b\u8f91\u9519\u8bef\uff0c\u4ec5\u53d1\u653e\u5269\u4f59\u7684\u5956\u54c1\uff0c\u6d3b\u52a8ID[{}],\u5546\u54c1ID[{}]", (Object)privilege.getId(), (Object)privilege.getCommodityId());
        }
        boolean virtualPrize = prizeCount == 0;
        int index = 0;
        for (Long winnerId : winnerSet) {
            if (!virtualPrize && prizeCount == 0) break;
            WinnerBean winner = new WinnerBean();
            Optional<ParticipantBean> relation = relationWinners.stream().filter(entity -> Objects.equals(entity.getInviteUserId(), winnerId)).findFirst();
            if (relation.isPresent()) {
                ParticipantBean relationBean = relation.get();
                winner.setInviteFlag(1);
                winner.setInviteUserId(relationBean.getInviteUserId());
            } else {
                winner.setInviteFlag(0);
            }
            winner.setId(Long.valueOf(this.nextId()));
            winner.setUserId(winnerId);
            winner.setPrivilegeId(Long.valueOf(privilege.getId()));
            winner.setRedeemFlag(0);
            winner.setAddTime(new Date());
            if (!virtualPrize) {
                winner.setCommodityCode(((CommodityCodeBean)prizeList.get(index)).getCode());
            }
            winners.add(winner);
            ++index;
            --prizeCount;
        }
        new BatchHelper<WinnerMapper, WinnerBean>(WinnerMapper.class, (Collection)winners, "primarySessionTemplate"){

            protected int invoke(WinnerBean element) {
                return ((WinnerMapper)this.mapper).insert(element);
            }
        };
        if (virtualPrize) {
            this.winnerMapper.updateWinnerPrizeCode(privilege.getId());
        } else if (winners.size() < privilege.getPrizeNum()) {
            int num = privilege.getPrizeNum() - winners.size();
            this.commodityService.execStoreReturned(privilege.getCommodityId(), num, privilege.getId());
        }
        this.sendMessage(privilege, winners, participants);
    }

    private void sendMessage(PrivilegeBean privilege, List<WinnerBean> winners, List<ParticipantBean> participants) {
        if (this.adminBizConfigProperties.isPrivilegePushMsg()) {
            this.sendWinnerPush(privilege, winners);
            this.sendParticipantPush(privilege, participants);
        } else {
            this.logger.info("\u6d3b\u52a8[{}]\u5df2\u53d1\u5956", (Object)privilege);
            this.logger.info("\u83b7\u5956\u4eba\u5458\uff1a[{}]", winners);
            this.logger.info("\u672a\u83b7\u5956\u7684\u53c2\u4e0e\u4eba\u4eba\u5458\uff1a[{}]", participants);
        }
    }

    private void sendWinnerPush(PrivilegeBean privilege, List<WinnerBean> winners) {
    }

    private void sendParticipantPush(PrivilegeBean privilege, List<ParticipantBean> participants) {
    }
}

