/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.AdminToolsLocationMapper;
import com.bxm.localnews.admin.domain.AdminToolsMapper;
import com.bxm.localnews.admin.dto.TooltipStrategyDTO;
import com.bxm.localnews.admin.enums.AreaWhiteBlackKeyEnum;
import com.bxm.localnews.admin.enums.TooltipStrategyEnum;
import com.bxm.localnews.admin.param.ToolsInfoParam;
import com.bxm.localnews.admin.param.ToolsParam;
import com.bxm.localnews.admin.service.base.AdminToolsService;
import com.bxm.localnews.admin.vo.Tools;
import com.bxm.localnews.admin.vo.ToolsLocation;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AdminToolsServiceImpl
implements AdminToolsService {
    @Resource
    private AdminToolsMapper adminToolsMapper;
    @Resource
    private AdminToolsLocationMapper adminToolsLocationMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public PageWarper<Tools> getToolsList(ToolsParam toolsParam) {
        PageWarper pageWrapper = new PageWarper(this.adminToolsMapper.queryToolsList(toolsParam));
        if (CollectionUtils.isNotEmpty((Collection)pageWrapper.getList())) {
            pageWrapper.getList().forEach(tool -> {
                if (0 == tool.getGlobalFlag()) {
                    tool.setLocationList(this.adminToolsLocationMapper.getToolsLocationByToolId(tool.getId()));
                }
            });
        }
        return pageWrapper;
    }

    @Override
    public Tools getToolsById(Long id) {
        Tools tools = this.adminToolsMapper.selectByPrimaryKey(id);
        tools.setLocationList(this.adminToolsLocationMapper.getToolsLocationByToolId(tools.getId()));
        return tools;
    }

    @Override
    public int updateToolsStatusById(List<String> ids, Byte status) {
        int update = this.adminToolsMapper.updateToolsStatusById(ids, status);
        this.removeCache();
        return update;
    }

    @Override
    public int saveOrUpdate(ToolsInfoParam toolsInfoParam) {
        int operationResult;
        Tools toolInfo = new Tools();
        BeanUtils.copyProperties((Object)toolsInfoParam, (Object)toolInfo);
        if (null == toolInfo.getId()) {
            toolInfo.setId(this.sequenceCreater.nextLongId());
            operationResult = this.adminToolsMapper.insertSelective(toolInfo);
        } else {
            operationResult = this.adminToolsMapper.updateByPrimaryKeySelective(toolInfo);
        }
        this.updateToolsLocation(toolInfo.getId(), toolsInfoParam.getToolAreaList());
        this.removeCache();
        return operationResult;
    }

    @Override
    public int deleteTools(Long id) {
        int update = this.adminToolsMapper.deleteByPrimaryKey(id);
        this.removeCache();
        return update;
    }

    @Override
    public List<TooltipStrategyDTO> getAllTooltipStrategy() {
        ArrayList<TooltipStrategyDTO> resultList = new ArrayList<TooltipStrategyDTO>();
        for (TooltipStrategyEnum tooltipStrategyEnum : TooltipStrategyEnum.values()) {
            TooltipStrategyDTO tooltipStrategyDTO = new TooltipStrategyDTO();
            tooltipStrategyDTO.setName(tooltipStrategyEnum.getName());
            tooltipStrategyDTO.setDescription(tooltipStrategyEnum.getDescription());
            resultList.add(tooltipStrategyDTO);
        }
        return resultList;
    }

    private void updateToolsLocation(Long toolId, List<ToolsLocation> toolAreaList) {
        this.adminToolsLocationMapper.deleteByToolId(toolId);
        this.insertToolsLocation(toolAreaList, toolId);
    }

    private void insertToolsLocation(List<ToolsLocation> toolAreaList, Long toolId) {
        if (CollectionUtils.isEmpty(toolAreaList)) {
            return;
        }
        ArrayList toolsLocations = new ArrayList(toolAreaList.size());
        toolAreaList.forEach(toolAreaInfo -> {
            ToolsLocation toolsLocation = new ToolsLocation();
            toolsLocation.setId(this.sequenceCreater.nextLongId());
            toolsLocation.setAreaCode(toolAreaInfo.getAreaCode());
            toolsLocation.setToolId(toolId);
            toolsLocation.setAreaType(toolAreaInfo.getAreaType());
            toolsLocations.add(toolsLocation);
        });
        this.adminToolsLocationMapper.insertToolsLocations(toolsLocations);
    }

    private void removeCache() {
        this.redisHashMapAdapter.remove(RedisConfig.AREA_WHITE_BLACK_LIST.copy().appendKey((Object)AreaWhiteBlackKeyEnum.TOOLS.getKey()));
    }
}

