/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.LocationChannelAreaMapper;
import com.bxm.localnews.admin.domain.LocationChannelMapper;
import com.bxm.localnews.admin.dto.ChannelInfoDetailDTO;
import com.bxm.localnews.admin.dto.UserChannelDTO;
import com.bxm.localnews.admin.param.UserChannelParam;
import com.bxm.localnews.admin.service.base.UserChannelService;
import com.bxm.localnews.admin.vo.LocationChannelBean;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserChannelServiceImpl
extends BaseService
implements UserChannelService {
    @Autowired
    private LocationChannelMapper locationChannelMapper;
    @Autowired
    private LocationChannelAreaMapper locationChannelAreaMapper;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public PageWarper<UserChannelDTO> getList(UserChannelParam userChannelParam) {
        PageInfo pageInfo = new PageInfo(this.locationChannelMapper.getList(userChannelParam));
        ArrayList resultList = new ArrayList();
        pageInfo.getList().forEach(locationChannelBean -> resultList.add(this.convert((LocationChannelBean)locationChannelBean)));
        PageWarper pageWarper = new PageWarper(resultList);
        pageWarper.setPageNum(pageInfo.getPageNum());
        pageWarper.setPageSize(pageInfo.getPageSize());
        pageWarper.setTotal(pageInfo.getTotal());
        return pageWarper;
    }

    @Override
    public ChannelInfoDetailDTO getDetail(UserChannelParam userChannelParam) {
        LocationChannelBean locationChannelBean = this.locationChannelMapper.selectByPrimaryKey(userChannelParam.getChannelId());
        ChannelInfoDetailDTO userChannelDTO = new ChannelInfoDetailDTO();
        BeanUtils.copyProperties((Object)locationChannelBean, (Object)userChannelDTO);
        userChannelDTO.setId(locationChannelBean.getId() + "");
        userChannelDTO.setChannelAreaDTOS(this.locationChannelAreaMapper.getListByChannelId(locationChannelBean.getId()));
        return userChannelDTO;
    }

    @Override
    public Boolean updateStatus(UserChannelParam userChannelParam) {
        if (this.locationChannelMapper.updateStatus(userChannelParam.getChannelId()) > 0) {
            ChannelInfoDetailDTO channelInfoDetailDTO = this.getDetail(userChannelParam);
            this.resetRedis(channelInfoDetailDTO);
            return true;
        }
        return false;
    }

    @Override
    public Boolean insert(ChannelInfoDetailDTO channelInfoDetailDTO) {
        LocationChannelBean bean = new LocationChannelBean();
        BeanUtils.copyProperties((Object)channelInfoDetailDTO, (Object)bean);
        bean.setId(Long.valueOf(this.nextId()));
        if (this.locationChannelMapper.insertSelective(bean) > 0 && null != channelInfoDetailDTO.getChannelAreaDTOS() && !channelInfoDetailDTO.getChannelAreaDTOS().isEmpty()) {
            channelInfoDetailDTO.getChannelAreaDTOS().forEach(entity -> {
                entity.setLocationChannelId(bean.getId());
                entity.setAreaType(bean.getGlobalStatus());
            });
            this.locationChannelAreaMapper.batchInsert(channelInfoDetailDTO.getChannelAreaDTOS());
        }
        channelInfoDetailDTO.setId(Objects.toString(bean.getId()));
        this.resetRedis(channelInfoDetailDTO);
        return true;
    }

    @Override
    public Boolean update(ChannelInfoDetailDTO channelInfoDetailDTO) {
        if (null == channelInfoDetailDTO.getId()) {
            return false;
        }
        this.resetRedis(channelInfoDetailDTO);
        LocationChannelBean bean = new LocationChannelBean();
        BeanUtils.copyProperties((Object)channelInfoDetailDTO, (Object)bean);
        bean.setId(Long.valueOf(Long.parseLong(channelInfoDetailDTO.getId())));
        if (this.locationChannelMapper.updateByPrimaryKeySelective(bean) > 0) {
            this.locationChannelAreaMapper.deleteByLocationId(Long.valueOf(Long.parseLong(channelInfoDetailDTO.getId())));
            if (!CollectionUtils.isEmpty((Collection)channelInfoDetailDTO.getChannelAreaDTOS())) {
                channelInfoDetailDTO.getChannelAreaDTOS().forEach(entity -> {
                    if (null == entity.getLocationChannelId()) {
                        entity.setLocationChannelId(bean.getId());
                        entity.setAreaType(bean.getGlobalStatus());
                    }
                });
                this.locationChannelAreaMapper.batchInsert(channelInfoDetailDTO.getChannelAreaDTOS());
            }
        }
        return true;
    }

    @Override
    public List<LocationChannelBean> getEnableList() {
        return this.locationChannelMapper.getEnableChannel();
    }

    private UserChannelDTO convert(LocationChannelBean bean) {
        return UserChannelDTO.builder().channelName(bean.getChannelName()).channelUrl(bean.getChannelUrl()).focusOn(bean.getFocusOn()).status(bean.getStatus()).id(bean.getId() + "").isFixed(bean.getIsFixed()).globalStatus(bean.getGlobalStatus()).defaultChose(bean.getDefaultChose()).sort(bean.getSort()).name(bean.getGlobalStatus() == 1 ? "\u5168\u56fd" : bean.getName()).build();
    }

    private void resetRedis(ChannelInfoDetailDTO channelInfoDetailDTO) {
        if (channelInfoDetailDTO.getGlobalStatus().equals(1)) {
            this.redisHashMapAdapter.increment(RedisConfig.LOCATION_VERSION_CACHE, "0", 1);
        } else {
            List listAreaBean = this.locationChannelAreaMapper.getListByChannelId(Long.valueOf(Long.parseLong(channelInfoDetailDTO.getId())));
            if (CollectionUtils.isNotEmpty((Collection)listAreaBean)) {
                if (CollectionUtils.isNotEmpty((Collection)channelInfoDetailDTO.getChannelAreaDTOS())) {
                    listAreaBean.removeAll(channelInfoDetailDTO.getChannelAreaDTOS());
                }
                listAreaBean.forEach(entity -> this.redisHashMapAdapter.increment(RedisConfig.LOCATION_VERSION_CACHE, entity.getAreaCode(), 1));
            }
            if (!CollectionUtils.isEmpty((Collection)channelInfoDetailDTO.getChannelAreaDTOS())) {
                channelInfoDetailDTO.getChannelAreaDTOS().forEach(entity -> this.redisHashMapAdapter.increment(RedisConfig.LOCATION_VERSION_CACHE, entity.getAreaCode(), 1));
            }
        }
    }
}

