/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.domain.UserTagMapper;
import com.bxm.localnews.admin.service.base.UserCommonTagService;
import com.bxm.localnews.admin.service.base.UserTagService;
import com.bxm.localnews.admin.vo.UserCommonTag;
import com.bxm.localnews.admin.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserTagServiceImpl
extends BaseService
implements UserTagService {
    private static final Logger log = LogManager.getLogger(UserTagServiceImpl.class);
    @Autowired
    private UserCommonTagService userCommonTagService;
    @Autowired
    private UserTagMapper userTagMapper;

    @Override
    public void save(Long userId, List<Long> userCommonTagIds) {
        if (null == userId || CollectionUtils.isEmpty(userCommonTagIds)) {
            return;
        }
        Map<Long, UserCommonTag> userCommonTagMap = this.userCommonTagService.getUserCommonTagMap();
        List<UserCommonTag> userCommonTags = userCommonTagIds.stream().map(userCommonTagMap::get).sorted(Comparator.comparing(UserCommonTag::getOrder)).collect(Collectors.toList());
        this.userTagMapper.batchInsert(this.convertToUserTags(userId, userCommonTags));
    }

    private List<UserTag> convertToUserTags(Long userId, List<UserCommonTag> userCommonTags) {
        ArrayList userTags = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userCommonTags)) {
            for (int i = 0; i < userCommonTags.size(); ++i) {
                UserTag userTag = new UserTag();
                userTag.setId(this.nextSequence());
                userTag.setLabel(userCommonTags.get(i).getLabel());
                userTag.setOrder(Integer.valueOf(i));
                userTag.setUserId(userId);
                userTag.setDefaultFlag(Byte.valueOf((byte)1));
                userTag.setCreateTime(new Date());
                userTags.add(userTag);
            }
        }
        return userTags;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(Long userId, List<Long> userCommonTagIds) {
        if (null == userId) {
            return;
        }
        this.userTagMapper.deleteAll(userId);
        this.save(userId, userCommonTagIds);
    }
}

