/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.security;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.common.SecurityConfigurationProperties;
import com.bxm.localnews.admin.vo.security.AdminUser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenService
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenService.class);
    private static final long serialVersionUID = -3301605591108950415L;
    private static final String CLAIM_KEY_USERNAME = "sub";
    private static final String CLAIM_KEY_CREATED = "created";
    private final SecurityConfigurationProperties properties;

    @Autowired
    public JwtTokenService(SecurityConfigurationProperties properties) {
        this.properties = properties;
    }

    private Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + this.properties.getJwtTokenExpiration() * 1000L);
    }

    public String generateToken(AdminUser userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(CLAIM_KEY_USERNAME, userDetails.getId());
        claims.put(CLAIM_KEY_CREATED, new Date());
        String token = this.generateToken(claims);
        log.debug("\u521b\u5efatoken\uff0c\u7528\u6237\u4fe1\u606f\uff1a{},token:{}", (Object)JSON.toJSONString((Object)userDetails), (Object)token);
        return token;
    }

    private String generateToken(Map<String, Object> claims) {
        return Jwts.builder().setClaims(claims).setExpiration(this.generateExpirationDate()).signWith(SignatureAlgorithm.HS512, this.properties.getJwtSecret()).compact();
    }
}

