/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.AdminRoleMapper;
import com.bxm.localnews.admin.domain.AdminUserMapper;
import com.bxm.localnews.admin.domain.AdminUserRoleMapper;
import com.bxm.localnews.admin.domain.UserInviteHistoryMapper;
import com.bxm.localnews.admin.domain.UserVipMapper;
import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.dto.OrderInfoDTO;
import com.bxm.localnews.admin.dto.Tuple;
import com.bxm.localnews.admin.dto.UserInviteCollectDTO;
import com.bxm.localnews.admin.enums.OrderTypeEnum;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.param.UserActivationCardParam;
import com.bxm.localnews.admin.service.security.AdminUserService;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.admin.vo.security.AdminUserRole;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminUserServiceImpl
implements AdminUserService {
    private static final Logger log = LoggerFactory.getLogger(AdminUserServiceImpl.class);
    private AdminUserMapper adminUserMapper;
    private AdminRoleMapper adminRoleMapper;
    private RedisHashMapAdapter redisHashMapAdapter;
    private AdminUserRoleMapper adminUserRoleMapper;
    private UserVipMapper userVipMapper;
    private KeyGenerator tokenKey = DefaultKeyGenerator.build((String)"admin", (String)"cache", (String)"user");
    private final UserInviteHistoryMapper userInviteHistoryMapper;

    @Autowired
    public AdminUserServiceImpl(RedisStringAdapter redisStringAdapter, AdminRoleMapper adminRoleMapper, RedisHashMapAdapter redisHashMapAdapter, AdminUserRoleMapper adminUserRoleMapper, UserVipMapper userVipMapper, AdminUserMapper adminUserMapper, UserInviteHistoryMapper userInviteHistoryMapper) {
        this.adminUserMapper = adminUserMapper;
        this.adminRoleMapper = adminRoleMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.adminUserRoleMapper = adminUserRoleMapper;
        this.userVipMapper = userVipMapper;
        this.userInviteHistoryMapper = userInviteHistoryMapper;
    }

    @Override
    public AdminUser getUser(String userName) {
        return this.adminUserMapper.getByUserName(userName);
    }

    @Override
    public void removeToken(Long userId) {
        log.debug("\u79fb\u9664\u7528\u6237token\uff0cuserId:{}", (Object)userId);
        if (null != userId) {
            this.redisHashMapAdapter.remove(this.tokenKey, new String[]{String.valueOf(userId)});
        }
    }

    @Override
    public void addTokenCache(Long userId, String token) {
        log.debug("\u521b\u5efa\u7528\u6237TOKEN\uff0cuserId:{},token:{}", (Object)userId, (Object)token);
        if (null != userId && null != token) {
            this.redisHashMapAdapter.put(this.tokenKey, String.valueOf(userId), (Object)token);
        }
    }

    @Override
    public Json modifyPassword(AdminUserDTO param) {
        String oldPassword = MD5Util.hgmd5((String)param.getOldPassword());
        String newPassword = MD5Util.hgmd5((String)param.getNewPassword());
        AdminUser oldSysUser = this.adminUserMapper.getByUserName(param.getUsername());
        if (null == oldSysUser) {
            return ResultUtil.genFailedResult((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!oldSysUser.getPassword().equals(oldPassword)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u539f\u5bc6\u7801\u8f93\u5165\u4e0d\u6b63\u786e");
        }
        if (oldSysUser.getPassword().equals(newPassword)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u76f8\u540c");
        }
        oldSysUser.setPassword(newPassword);
        this.editUserPassWord(oldSysUser);
        this.removeToken(oldSysUser.getId());
        return ResultUtil.genSuccessMsg((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
    }

    @Override
    public Json modifyPasswordByAdmin(AdminUserDTO param) {
        String newPassword = MD5Util.hgmd5((String)param.getNewPassword());
        AdminUser oldSysUser = this.adminUserMapper.getByUserName(param.getUsername());
        if (null == oldSysUser) {
            return ResultUtil.genFailedResult((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        oldSysUser.setPassword(newPassword);
        this.editUserPassWord(oldSysUser);
        this.removeToken(oldSysUser.getId());
        return ResultUtil.genSuccessMsg((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
    }

    @Override
    public Boolean editUserPassWord(AdminUser sysUser) {
        this.removeToken(sysUser.getId());
        return this.adminUserMapper.editUserPassWord(sysUser);
    }

    @Override
    public PageWarper<AdminUserDTO> queryAdminUsers(AdminUserParam adminUserParam) {
        Preconditions.checkArgument((adminUserParam != null ? 1 : 0) != 0);
        PageHelper.startPage((int)adminUserParam.getPageNum(), (int)adminUserParam.getPageSize());
        List list = this.adminUserMapper.queryAdminUser(adminUserParam);
        PageWarper pageWarper = new PageWarper(list);
        return pageWarper;
    }

    @Override
    public AdminUser selectByUsername(String username) {
        return this.adminUserMapper.selectByUsername(username);
    }

    @Override
    public int upsert(AdminUserDTO user) {
        String password = MD5Util.hgmd5((String)user.getPassword());
        user.setPassword(password);
        this.removeToken(user.getId());
        return this.adminUserMapper.upsert(user);
    }

    @Override
    public int updateByPrimaryKeySelective(AdminUser record) {
        String password = MD5Util.hgmd5((String)record.getPassword());
        record.setPassword(password);
        this.removeToken(record.getId());
        return this.adminUserMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public AdminUser selectById(Long id) {
        return this.adminUserMapper.selectById(id);
    }

    @Override
    public Message updateUserRole(Long userId, Integer roleId) {
        Long exitRoleId = this.adminRoleMapper.selectRoleIdByUserId(userId);
        AdminUserRole adminUserRole = new AdminUserRole();
        adminUserRole.setUserId(userId);
        adminUserRole.setRoleId(roleId);
        if (Objects.isNull(exitRoleId)) {
            this.adminUserRoleMapper.insertSelective(adminUserRole);
        } else {
            this.adminUserRoleMapper.updateRoleByUserId(adminUserRole);
        }
        return Message.build((boolean)true);
    }

    @Override
    public List<AdminUserDTO> getAvailableAdminUser() {
        AdminUserParam adminUserParam = new AdminUserParam();
        adminUserParam.setStatus(Integer.valueOf(0));
        return this.adminUserMapper.queryAdminUser(adminUserParam);
    }

    @Override
    public PageWarper<OrderInfoDTO> getOpenCardPageList(UserActivationCardParam userActivationCardParam) {
        Preconditions.checkArgument((userActivationCardParam != null ? 1 : 0) != 0);
        userActivationCardParam.setPayType(OrderTypeEnum.WELFARE_VIP.getCode());
        PageHelper.startPage((int)userActivationCardParam.getPageNum(), (int)userActivationCardParam.getPageSize());
        List list = this.userVipMapper.getPageList(userActivationCardParam);
        List idList = list.stream().map(OrderInfoDTO::getUserId).collect(Collectors.toList());
        List parentInfoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(idList)) {
            parentInfoList = this.userVipMapper.getParentInfoById(idList);
        }
        for (OrderInfoDTO item : list) {
            if (StringUtils.equals((CharSequence)item.getActivationType(), (CharSequence)"0")) {
                item.setActivationType("\u4ed8\u8d39\u5f00\u901a");
            } else if (StringUtils.equals((CharSequence)item.getActivationType(), (CharSequence)"1")) {
                item.setActivationType("\u6fc0\u6d3b\u7801");
            } else if (StringUtils.equals((CharSequence)item.getActivationType(), (CharSequence)"2")) {
                item.setActivationType("\u8fd0\u8425\u5f00\u901a");
            } else {
                item.setActivationType("\u672a\u77e5");
            }
            parentInfoList.forEach(info -> {
                if (Objects.equals(info.getUserId(), item.getUserId())) {
                    item.setParentNickName(info.getParentNickName());
                    item.setParentPhone(info.getParentPhone());
                }
            });
            UserInviteCollectDTO collect = this.getCollect(item.getUserId());
            if (!Objects.nonNull(collect)) continue;
            item.setTotal(collect.getTotal());
            item.setTodayTotal(collect.getTodayTotal());
            item.setYesterdayTotal(collect.getYesterdayTotal());
            item.setOneLevel(collect.getOneLevel());
            item.setTwoLevel(collect.getTwoLevel());
        }
        return new PageWarper(list);
    }

    private UserInviteCollectDTO getCollect(Long userId) {
        List collectList = this.userInviteHistoryMapper.getCollect(userId);
        String todayFormat = DateUtils.formatDate((Date)new Date());
        Calendar yesterdayCalendar = Calendar.getInstance();
        yesterdayCalendar.setTime(new Date());
        yesterdayCalendar.add(6, -1);
        String yesterdayFormat = DateUtils.formatDate((Date)yesterdayCalendar.getTime());
        int total = 0;
        int today = 0;
        int yesterday = 0;
        for (Tuple tuple : collectList) {
            total += tuple.getTotal();
            if (StringUtils.equals((CharSequence)todayFormat, (CharSequence)tuple.getLabel())) {
                today = tuple.getTotal();
            }
            if (!StringUtils.equals((CharSequence)yesterdayFormat, (CharSequence)tuple.getLabel())) continue;
            yesterday = tuple.getTotal();
        }
        Integer levelOne = this.userInviteHistoryMapper.getCollectLevel(userId, Integer.valueOf(1));
        UserInviteCollectDTO result = new UserInviteCollectDTO();
        result.setTodayTotal(Integer.valueOf(today));
        result.setYesterdayTotal(Integer.valueOf(yesterday));
        result.setTotal(Integer.valueOf(total));
        result.setOneLevel(levelOne);
        result.setTwoLevel(Integer.valueOf(total - levelOne));
        return result;
    }
}

