package com.bxm.localnews.common.constant;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;

import java.util.Arrays;
import java.util.stream.Stream;

/**
 * Created by Administrator on 2018/2/24.
 */
public enum TaskEnum {
    READ_PUSH_ARTICLE((byte) 11, "阅读推送新闻", new String[]{"otherReward", "goldReward"}, null),
    REGISTER((byte) 18, "用户注册", new String[]{"moneyReward", "redPacketMoney"}, null),
    SIGN_DAILY((byte) 20, "每日签到", new String[]{"otherReward", "goldReward"}, null),
    BALANCE_EXCHANGE_GOODS((byte) 27, "金币兑换商品", new String[]{"otherReward", "goldReward"}, null),
    STORE_ADD_BALANCE((byte) 30, "积分商城添加金币", new String[]{"otherReward", "goldReward"}, null),

    TASK_NEWS_SHARE((byte) 9, "分享", new String[]{"shareArtical", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_NEWS_READ((byte) 10, "看新闻", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_INVITED_FRIEND((byte) 31, "邀请好友", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_VIDEO_READ((byte) 32, "看视频", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_IMPROVE_USER_INFO((byte) 34, "完善个人资料", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_ACTIVATION_VIP((byte) 35, "激活VIP一年", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED);

    private byte type;

    private String desc;

    /**
     * 每日统计表中需要变化的列
     */
    private String[] tableColumn;

    private PushMessageEnum pushMessageEnum;

    TaskEnum(byte type, String desc, String[] tableColumn, PushMessageEnum pushMessageEnum) {
        this.type = type;
        this.desc = desc;
        this.tableColumn = tableColumn;
        this.pushMessageEnum = pushMessageEnum;
    }

    public static String getDescByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() == type) {
                return taskTypeEnum.getDesc();
            }
        }
        return null;
    }

    public static String[] getTableColumByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() == type) {
                return taskTypeEnum.getTableColumn();
            }
        }
        return null;
    }

    public static PushMessageEnum getPushMessageEnumByDesc(String desc) {
        return Stream.of(TaskEnum.values()).filter(taskTypeEnum ->
                desc.equals(taskTypeEnum.getDesc())).findAny().get().getPushMessageEnum();
    }

    public static TaskEnum getTaskByDesc(String desc) {
        return Arrays.asList(TaskEnum.values()).stream().filter(taskEnum -> desc.equals(taskEnum.getDesc())).findFirst().get();
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String[] getTableColumn() {
        return this.tableColumn;
    }

    public void setTableColumn(String[] tableColumn) {
        this.tableColumn = tableColumn;
    }

    public PushMessageEnum getPushMessageEnum() {
        return pushMessageEnum;
    }
}
