package com.bxm.localnews.common.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 通用的业务配置，具体模块的配置需要在对应的模块内创建properties和特定的前缀接收
 *
 * @author liujia 2018/7/26 16:45
 */
@Component
@ConfigurationProperties("common.config")
@Data
public class BizConfigProperties {

    /**
     * api签名加密密钥
     */
    private String apiSignKey;

    /**
     * 当前环节（遗留系统需要此值）
     */
    private int env;

    /**
     * 允许访问的请求来源，通过“,”分割
     */
    private String allowOrigins;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 临时文件存储目录
     */
    private String tempDir;

    /**
     * 是否启用方法签名
     */
    private Boolean enableRequestSign;

    /**
     * 白名单账号（用于app提包时提供的特殊账号）
     */
    private List<String> whiteList = Lists.newArrayList();

    /**
     * 安卓限制展示渠道列表(不同的渠道需要过包时进行敏感功能隐藏)
     */
    private List<String> disableAndroidChannel = Lists.newArrayList();

    /**
     * 是否开启上线检查开关（1：提包状态（敏感信息隐藏）,2:正常显示）
     */
    private String switchType;

    /**
     * 安卓拉新活动的apk下载包，apk文件路径.如果需要更新下载包，请保证下载包的名称有变化
     * 同名包只会下载一次
     */
    private String inviteAndriodApkUrl;

    /**
     * 区域编码
     */
    private String locationCode;

    /**
     * 区域名称
     */
    private String locationName;

    /**
     * 活动分享链接
     */
    private String privilegeShareUrl;

    /**
     * 业务打点日志的请求路径
     */
    private String bizLogUrl;

    /**
     * 客服微信号
     */
    private String customerServiceNumber;

    /**
     * 微信访问token
     */
    private String weixinAccessToken;

    /**
     * 日志埋点版本号，跟随客户端主版本号迭代
     */
    private String pointVersion = "3.3.1";

    /**
     * 最大的附近城市推荐数量 默认15
     */
    private Integer maxNearbyCityRecommendNum = 15;

    /**
     * 城市码特殊处理开关
     * 默认开启
     */
    private Boolean codeProcessSwitch = Boolean.TRUE;

    /**
     * 团购订单客服（默认全国客服）
     */
    private String groupCustomerPhone;

    /**
     * 团购订单客服名称（默认全国客服）
     */
    private String groupCustomerName = "陈先生";

    /**
     * 微信公众号
     */
    private String officialAccountQrcode;


    public String getTempDir() {
        if (null == this.tempDir) {
            this.tempDir = "/opt/tmp/";
        } else if (!this.tempDir.endsWith("/")) {
            this.tempDir = tempDir + "/";
        }
        return this.tempDir;
    }
}
