package com.bxm.localnews.common.constant;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 全局常量定义
 * @author liujia
 */
@SuppressWarnings("ALL")
public class AppConst {
    //通用状态

    /**
     * 禁用
     */
    public static final Byte STATE_DISABLE = 10;

    /**
     * 可使用
     */
    public static final Byte STATE_USE = 20;

    public final static String SIGN_PARAM_NAME = "apiSign";

    public final static Map<Byte, String> PLATFORM_NAME_MAP = new HashMap<>();

    /**
     * 用户被唤醒时间到登录之间的限制时间(小时)
     */
    public final static int AWAKE_HOURS_BETWEEN = 24;

    //奖励类型

    /**
     * 金币
     */
    public final static byte REWARD_TYPE_GOLD = 10;

    /**
     * 零钱
     */
    public final static byte REWARD_TYPE_COIN = 20;

    /**
     * 阅读文章获取金币数
     */
    public final static int READ_REWARD_GOLD_NUM = 10;

    /**
     * 阅读推荐文章获取金币数
     */
    public final static int READ_RECOMMEND_REWARD_GOLD_NUM = 10;

    /**
     * 是否是推荐的文章
     */
    public final static String IS_RECOMMEND_NEWS = "2";

    /**
     * 分享成功获取金币数
     * wztt分享获得20改成wst获得10
     */
    public final static BigDecimal SHARE_REWARD_GOLD_NUM = new BigDecimal("10");


    /**
     * 新闻详情页推荐文章数量
     */
    public final static int NEWS_DETAIL_RECOMMEND_NUM = 5;

    /**
     * 每次刷新条数 12+3(广告) = 15
     */
    public final static int REFRESH_VIDEO_NUM = 12;

    /**
     * 邀请新用户获得奖励金币
     */
    public final static BigDecimal INVITE_NEW_USER_REWARD_GOLD_NUM = new BigDecimal("500");

    /**
     * 邀请新用户获得奖励金币
     */
    public final static BigDecimal BEEN_INVITED_NEW_USER_REWARD_GOLD_NUM = new BigDecimal("100");

    static {
        PLATFORM_NAME_MAP.put(PLATFORM.ANDROID, "android");
        PLATFORM_NAME_MAP.put(PLATFORM.IOS, "ios");
        PLATFORM_NAME_MAP.put(PLATFORM.WEB, "web");
    }

    /**
     * 新闻类型
     */
    public final static class NEWS {

        /**
         * 文章
         */
        public final static byte ESSAY = 1;

        /**
         * 组图
         */
        public final static byte ICON_ESSAY = 2;

        /**
         * 视频
         */
        public final static byte VIDEO = 3;

    }

    public static class Sms {
        //短信发送器

        /**
         * 示远短信
         */
        public final static byte SHIYUAN = 10;

        //短信状态

        /**
         * 未使用
         */
        public final static Byte STATUS_UNUSED = 10;

    }

    /**
     * 短信发送模板
     */
    public static class SMS_TPL {

        //短信发送器

        /**
         * 手机登录
         */
        public final static byte VCODE_TYPE_LOGIN = 1;

        /**
         * 绑定手机号
         */
        public final static byte VCODE_TYPE_BIND_PHONE = 2;

        /**
         * 注册
         */
        public final static byte VCODE_TYPE_REGISTER = 3;

        /**
         * 找回密码
         */
        public final static byte VCODE_TYPE_RETRIEVE_PWD = 6;

        /**
         * 商户报名验证码短信
         */
        public final static byte MERCHANT_CODE = 7;

    }

    /**
     * 登录类型
     */
    public static class LOGIN_TYPE {

        /**
         * 手机号、密码登录
         */
        public final static byte PHONE = 1;

        /**
         * qq第三方登录
         */
        public final static byte QQ = 2;

        /**
         * 微信登录
         */
        public final static byte WEIXIN = 3;

        /**
         * 微博登录
         */
        public final static byte WEIBO = 4;

        /**
         * 微信公众号OPENID
         */
        public final static byte WEIXIN_OPENID = 5;

        /**
         * APP的OPENID
         */
        public final static byte APP_OPENID = 6;

        /**
         * 微信小程序大转盘的OPENID
         */
        public final static byte WEIXIN_APPLET_OPENID = 7;

        /**
         * 微信小程序万事通的OPENID
         */
        public final static byte WEIXIN_APPLET_WST_OPENID = 8;

    }

    /**
     * 请求平台
     */
    public final static class PLATFORM {

        public final static byte ANDROID = 1;

        public final static byte IOS = 2;

        public final static byte WEB = 3;

    }

    /**
     * 是否新用户
     */
    public final static class IS_NEW_USER {

        /**
         * 新用户
         */
        public final static byte NEW_USER = 0;

        /**
         * 老用户
         */
        public final static byte OLD_USER = 1;

    }

    public static class CLIENT_PULL_TYPE {

        /**
         * 下拉刷新
         */
        public final static byte DOWN = 1;

        /**
         * 上拉刷新
         */
        public final static byte UP = 2;

    }

    /**
     * 用户状态
     */
    public static class USER_STATE {

        /**
         * 游客
         */
        public final static byte VISITOR = 0;

        /**
         * 正常用户
         */
        public final static byte NORMAL = 1;

        /**
         * 黑名单用户
         */
        public final static byte BLACKLIST = 9;

    }

    /**
     * 用户唤醒状态
     */
    public static class AWAKE_STATE {

        /**
         * 用户状态 :活跃中
         */
        public static final byte AWAKE_STATE_ACTIVE = 10;

        /**
         * 待唤醒
         */
        public static final byte AWAKE_STATE_FREEZE = 20;

        /**
         * 唤醒中
         */
        public static final byte AWAKE_STATE_WAIT = 30;

    }

    /**
     * 获取短链接类型
     */
    public final static class SHORT_LINK_TYPE {

        /**
         * 注册
         */
        public final static byte REGISTER = 1;

        /**
         * 下载
         */
        public final static byte DOWNLOAD = 2;

        /**
         * 好友扫一扫
         */
        public final static byte FRIEND_SWEEP = 3;

    }

    /**
     * 获取分享信息类型
     */
    public final static class SHARE_INFO_TYPE {

        /**
         * 唤醒
         */
        public final static byte AWAKEN = 1;

        /**
         * 邀请收徒
         */
        public final static byte APPRENTICE = 2;

    }

}
