package com.bxm.localnews.common.constant;

/**
 * @author zhaoyadong 2018/10/20 14:30
 * @desc
 */
public enum PublishStateEnum {

    /** app版本状态 **/
    PURSE((byte)1, "提包状态"),
    NORMAL((byte)0, "正常状态");


    PublishStateEnum(Byte state, String name) {
        this.state = state;
        this.name = name;
    }

    public static PublishStateEnum getPublishStateEnum(Byte state) {

        for (PublishStateEnum publishStateEnum : PublishStateEnum.values()) {
            if (publishStateEnum.getState().equals(state)) {
                return publishStateEnum;
            }
        }

        return null;
    }

    private Byte state;

    private String name;

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
