package com.bxm.localnews.common.config;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块}
 *
 * @author pf.w
 * @date 2020/7/13 11:43
 */

public class MerchantRedisConfig {

    private MerchantRedisConfig() {
    }

    /**
     * base key
     */
    private static DefaultKeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("merchant").setGroup("cache");
    /**
     * 团队信息缓存 ： HASH
     */
    public static final KeyGenerator MEMBER_INFO_KEY = BASE_KEY.copy().appendKey("memberInfo");

}
