package com.bxm.localnews.base.domain;

import com.bxm.localnews.common.dto.DictDto;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface DictMapper {

    /**
     * 查询数据字典分组
     * @param group 数据字典分组
     * @return 数据字典列表
     */
    List<DictDto> query(String group);

    /**
     * 根据上级字典编码查询下级数据字典
     * @param parentCode 数据字典编码
     * @return 字典列表
     */
    List<DictDto> queryByParent(String parentCode);
}
