package com.bxm.localnews.base.facade;

import com.bxm.localnews.base.facade.fallback.DomainFacadeFallbackFactory;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.base.model.dto.ViewSceneDomain;
import com.bxm.localnews.common.constant.DomainScene;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * biz服务base模块的域名内部服务接口
 * @author gonzo
 * @date 2020-07-30 16:21
 **/
@FeignClient(value = "localnews", fallbackFactory = DomainFacadeFallbackFactory.class, primary = false)
public interface DomainFacadeService {

    /**
     * 根据场景获取域名
     * @param scene {@link DomainScene}
     * @param appId appId 某些场景如微信环境的授权，是需要appId和域名相互绑定的 所以需要传入app id来获取对应的域名
     * @param viewScene 落地页场景值 如果选择的是站外分享，则需要指定具体的落地页类型 CONTENT_VIEW: 站外内容落地页 PROMOTION_VIEW:
     *                  站外推广落地页 ACTIVITY_VIEW: 站外活动落地页
     *                  {@link DomainScene.DomainViewScene}
     * @return 包含了域名、baseUrl（如果有需要则会拼接）的信息
     */
    @RequestMapping("facade/base/domain/getBaseUrlInfoByScene")
    ResponseEntity<AvailableDomainInfo> getBaseUrlInfoByScene(@RequestParam("scene") String scene,
                                                              @RequestParam("viewScene") String viewScene,
                                                              @RequestParam("appId") String appId);

    /**
     * @param viewScene CONTENT_VIEW: 站外内容落地页 PROMOTION_VIEW: 站外推广落地页 ACTIVITY_VIEW: 站外活动落地页
     * @return 落地页的域名信息
     */
    @RequestMapping("facade/base/domain/getViewSceneBaseUrl")
    ResponseEntity<ViewSceneDomain> getViewSceneBaseUrl(@RequestParam("viewScene") String viewScene);
}
