package com.bxm.localnews.base.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.facade.DomainFacadeService;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.base.model.dto.ViewSceneDomain;
import com.bxm.localnews.base.model.param.GetAvailableDomainInfoParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author gonzo
 * @date 2020-07-30 20:24
 **/
@Component
@Slf4j
public class DomainFacadeFallbackFactory implements FallbackFactory<DomainFacadeService> {

    @Override
    public DomainFacadeService create(Throwable e) {
        return new DomainFacadeService() {

            @Override
            public ResponseEntity<AvailableDomainInfo> getBaseUrlInfoByScene(String scene, String viewScene, String appId) {
                log.error("调用biz服务的base模块接口失败 scene: {} viewScene: {} appId: {}", scene, viewScene, appId, e);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<ViewSceneDomain> getViewSceneBaseUrl(String viewScene) {
                log.error("调用biz服务的base模块接口失败 viewScene: {}", viewScene, e);
                return ResponseEntity.badRequest().build();
            }

        };
    }
}
