package com.bxm.localnews.base.model.dto;

import lombok.Data;

/**
 * @see com.bxm.localnews.common.vo.ViewSceneDomain
 *
 * 可用域名信息
 * @author gonzo
 * @date 2020-07-30 16:22
 **/
@Data
public class ViewSceneDomain {

    /**
     * 域名
     */
    private String domain;

    /**
     * 包含了domain以及部分跟路径的url
     * 根路径的拼接，是约定好按照场景进行的拼接
     * /结尾
     */
    private String baseUrl;

    /**
     * @see com.bxm.localnews.common.constant.DomainScene.DomainViewScene
     * 落地页场景类型
     */
    private String viewScene;
}
