package com.bxm.localnews.base.service;

/**
 * 业务日志记录服务接口
 */
public interface BizLogService {

    /**
     * 1002 新用户注册
     *
     * @param userId  用户ID
     * @param channel 注册渠道
     * @param token   用户第三方注册对应的token
     */
    void newUser(Long userId, String channel, String token);

    /**
     * 1003 用户登录
     *
     * @param userId 用户ID
     */
    void login(Long userId);

    /**
     * 1004 用户变更性别
     *
     * @param userId 用户ID
     * @param sex    性别，1：男，2：女
     */
    void changeGender(Long userId, int sex);

    /**
     * 1005 用户变更地区.在用户进行首次定位时获取
     *
     * @param userId   用户ID
     * @param areaCode 用户定位编码
     */
    void changeArea(Long userId, String areaCode);

    /**
     * 1008 扫描下载
     *
     * @param online  是否在线
     * @param pageSrc 页面来源
     * @param mid     商户ID
     * @param ip      ip
     */
    void scan(int online, String pageSrc, String mid, String ip);

    /**
     * 2006 用户拉新成功
     *
     * @param userId        邀请人ID
     * @param invitedUserId 被邀请人用户ID
     */
    void inviteSuccessed(Long userId, Long invitedUserId);

    /**
     * 3006 单个活动参与成功
     *
     * @param userId      参与活动的用户ID
     * @param privilegeId 活动ID
     */
    void joinPrivilege(Long userId, Long privilegeId);

    /**
     * 3009 用户邀请参与成功
     *
     * @param userId        发起用户ID
     * @param invitedUserId 被邀请人用户ID
     * @param privilegeId   活动ID
     */
    void invitePrivilege(Long userId, Long invitedUserId, Long privilegeId);

    /**
     * 3011 请求爆汁后台
     *
     * @param privilegeId 活动id
     * @param pageSource  投放页面渠道
     * @param isOnline    渠道性质-线上/线下
     * @param ip          用户ip地址
     */
    void baozhiPrivilege(Long privilegeId, String pageSource, Integer isOnline, String ip);

    /**
     * 用户购买VIP成功后调用
     *
     * @param userId 用户ID
     */
    void buyVip(Long userId);

    /**
     * 3024 VIP邀请用户成功
     *
     * @param userId 被邀请的用户ID
     */
    void inviteVip(Long userId);
}
