package com.bxm.localnews.base.service;

import com.bxm.localnews.base.dto.LocationDTO;
import com.bxm.localnews.base.dto.LocationDetailDTO;

import java.util.List;

public interface LocationFacadeService {

    /**
     * 根据code获取地区信息,暴露给用户模块使用
     */
    LocationDTO getLocationByCode(String code);

    /**
     * 根据code获取地区信息详情,暴露给用户模块使用
     */
    LocationDetailDTO getLocationDetailByCode(String code);

    /**
     * 用途：比较两个地理编码是否相同
     *
     * @param originalCode     用户传过来的地理位置编码
     * @param standardCodeList 12位的标准编码列表
     * @return
     */
    boolean compareLocationCode(String originalCode, List<String> standardCodeList);
}
