package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.vo.BasicParam;

/**
 * Created by Administrator on 2018/2/22 0022.
 */
public interface AppVersionSupplyService {

    /**
     * 是否处于提包状态
     *
     * @param basicParam
     * @return
     */
    Boolean getPublishState(BasicParam basicParam);

    /**
     * 判断手机号码是否在白名单中，用于提包时的校验
     *
     * @param phone 手机号码
     * @return true表示为后门账号（即白名单）
     */
    boolean inWhiteList(String phone);

    /**
     * 比较客户端版本与服务端版本
     *
     * @param curVer  客户端版本
     * @param version 服务端版本
     * @return -1：客户端版本低于服务端版本
     * 0：客户端版本等于服务端版本
     * 1：客户端版本高于服务端版本
     */
    int isHighVersion(String curVer, String version);


    /**
     * 获取对应手机类型的安装包版本
     *
     * @param basicParam
     * @param ip
     * @return
     */
    AppVersionDTO getAppVersion(BasicParam basicParam, String ip);
}
