package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.BaseDTO;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.List;

/**
 * 地区黑白名单接口
 */
public interface AreaWhiteBlackService {

    /**
     * 根据areaCode获取缓存
     *
     * @param key
     * @param areaCode
     * @param typeReference 泛型擦除问题，无法直接传T
     * @param <T>
     * @return
     */
    <T extends BaseDTO> List<T> getCacheByAreaCode(String key, String areaCode, TypeReference<List<T>> typeReference);

    /**
     * 黑白名单过滤
     *
     * @param totalList
     * @param whiteList
     * @param blackList
     * @param <T>
     * @return
     */
    <T extends BaseDTO> List<T> filterCacheByAreaCode(List<T> totalList, List<Long> whiteList, List<Long> blackList);

    /**
     * 根据areaCode设置缓存
     *
     * @param key
     * @param areaCode
     * @param dataList
     * @param <T>
     */
    <T extends BaseDTO> void setCacheByAreaCode(String key, String areaCode, List<T> dataList);

}
