package com.bxm.localnews.base.service;

import com.bxm.localnews.common.param.PointReportParam;

import java.math.BigDecimal;

/**
 * 业务日志记录服务接口
 */
public interface BizLogService {

    /**
     * 1002 新用户注册
     * @param userId  用户ID
     * @param channel 注册渠道
     * @param token   用户第三方注册对应的token
     * @param amount  账户余额
     */
    void newUser(Long userId, String channel, String token, BigDecimal amount, String registerChannel, String rid, Integer platform);

    /**
     * 1003 用户登录
     * @param userId 用户ID
     */
    void login(Long userId, Integer platform);

    /**
     * 1004 用户变更性别
     * @param userId 用户ID
     * @param sex    性别，1：男，2：女
     */
    void changeGender(Long userId, int sex, Integer platform);

    /**
     * 1005 用户变更地区.在用户进行首次定位时获取
     * @param userId   用户ID
     * @param areaCode 用户定位编码
     */
    void changeArea(Long userId, String areaCode, Integer platform);

    /**
     * 1008 扫描下载
     * @param online   是否在线
     * @param pageSrc  页面来源
     * @param mid      商户ID
     * @param areaCode 区域编码
     * @param ip       ip
     */
    void scan(int online, String pageSrc, String mid, String areaCode, String ip);

    /**
     * 2006 用户拉新成功
     * @param userId        邀请人ID
     * @param invitedUserId 被邀请人用户ID
     */
    void inviteSuccessed(Long userId, Long invitedUserId, Integer platform);

    /**
     * 3006 单个活动参与成功
     * @param userId      参与活动的用户ID
     * @param privilegeId 活动ID
     */
    void joinPrivilege(Long userId, Long privilegeId);

    /**
     * 3009 用户邀请参与成功
     * @param userId        发起用户ID
     * @param invitedUserId 被邀请人用户ID
     * @param privilegeId   活动ID
     */
    void invitePrivilege(Long userId, Long invitedUserId, Long privilegeId);

    /**
     * 3011 请求爆汁后台
     * @param privilegeId 活动id
     * @param pageSource  投放页面渠道
     * @param isOnline    渠道性质-线上/线下
     * @param ip          用户ip地址
     */
    void baozhiPrivilege(Long privilegeId, String pageSource, Integer isOnline, String ip);

    /**
     * 用户购买VIP成功后调用
     * @param userId 用户ID
     */
    void buyVip(Long userId);

    /**
     * 3024 VIP邀请用户成功
     * @param userId 被邀请的用户ID
     */
    void inviteVip(Long userId, Integer platform);

    /**
     * 3025 通过好友助力成功激活VIP
     * @param userId
     */
    void activateVip(Long userId, Integer platform);


    /**
     * 3028 抽奖符合地区要求的用户
     * @param userId
     * @param areaCode
     */
    void conformDrawAreaUser(Long userId, String areaCode);

    /**
     * 3029 记录用户转盘记录
     * @param userId
     * @param num    抽奖轮次
     * @param money  中奖金额
     */
    void lotteryDraw(Long userId, Integer num, BigDecimal money, Integer platform, String areaCode);

    /**
     * 3030 发起提现
     * @param userId
     * @param money  发起提现金额
     */
    void initiateWithdrawal(Long userId, BigDecimal money, Integer platform);

    /**
     * 3031 提现成功金额
     * @param userId
     * @param money
     */
    void successWithdrawal(Long userId, BigDecimal money);

    /**
     * 2007 发帖成功
     * @param userId   用户id
     * @param areaCode 地区code
     * @param platform
     */
    void forumSucceed(Long userId, String areaCode, Integer platform);

    /**
     * 2008 评论成功
     * @param userId   用户id
     * @param id       帖子或者新闻、小视频id
     * @param type     内容类型
     * @param areaCode 地区编码
     * @param platform
     */
    void replySucceed(Long userId, Long id, Integer type, String areaCode, Integer platform);

    /**
     * 2009 分享帖子成功
     * @param userId   用户id
     * @param id       帖子id
     * @param areaCode 区域编码
     * @param platform
     */
    void shareForumSucceed(Long userId, Long id, String areaCode, Integer platform);

    /**
     * 2010 帖子点赞成功
     * @param userId   用户id
     * @param id       帖子id
     * @param areaCode 地区编码
     * @param platform
     */
    void forumLikeSucceed(Long userId, Long id, String areaCode, Integer platform);

    /**
     * 2014 帖子收藏成功
     * @param userId   用户id
     * @param id       帖子id
     * @param areaCode 地区编码
     * @param type     类型
     * @param platform
     */
    void forumCollectSucceed(Long userId, Long id, String areaCode, Integer type, Integer platform);

    /**
     * 3032 发红包成功
     * @param userId
     */
    void sendRedPacket(Long userId, BigDecimal money, Integer platform);

    /**
     * 3033 成功领取红包
     * @param userId
     */
    void receiveRedPacket(Long userId, BigDecimal money, Integer platform);

    /**
     * 通用数据埋点上报
     * @param param
     */
    void report(PointReportParam param);
}
