package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Location;

import java.util.List;

public interface LocationFacadeService {

    /**
     * 根据code获取地区信息详情,暴露给用户模块使用
     * @see #getLocationDetailByCode(String, boolean)
     */
    LocationDetailDTO getLocationDetailByCode(String code);

    /**
     * 根据code获取地区信息详情,暴露给用户模块使用
     * @param code 区域编码
     * @param lastCodeQuery 是否使用code 查询最新的区域编码来匹配
     * @return
     */
    LocationDetailDTO getLocationDetailByCode(String code, boolean lastCodeQuery);


    LocationDetailDTO getInternalLocationByGeocode(String code,BasicParam basicParam);

    /**
     * 获取已开通VIP的地区详情
     *
     * @return
     */
    LocationDetailDTO getAcitivateVipLocation();

    /**
     * 用途：比较两个地理编码是否相同
     *
     * @param originalCode     用户传过来的地理位置编码
     * @param standardCodeList 12位的标准编码列表
     * @return
     */
    boolean compareLocationCode(String originalCode, List<String> standardCodeList);

    /**
     * 通过地区名称查询areaCode
     * @param name
     * @return
     */
    String getLocationByName(String name);

    /**
     * 更新地区中的开关
     * @param record
     */
    void update(Location record);

    /**
     * 地区编码转换成12位的编码,客户端获取的地区code有可能和数据库存储的地区code格式不一致
     *
     * @param areaCode 地区code
     * @return 适配后的地区code
     */
    String completeAreaCode(String areaCode);

}
