package com.bxm.localnews.base.service;

import com.bxm.localnews.common.constant.ShortLinkTypeEnum;
import com.bxm.localnews.common.dto.PrivilegeShareShortLinkDTO;
import com.bxm.localnews.common.vo.ShortLinkReq;

/**
 * 短链接服务接口
 * Created by mars on 2018/4/3.
 */
public interface ShortLinkService {

    /**
     * 获取分享注册连接
     *
     * @param req
     * @return
     */
    String getRegisterShortUrl(ShortLinkReq req);

    /**
     * 获取APP下载地址的短链接
     *
     * @return
     */
    String getDownloadShortUrl();

    /**
     * 获取好友扫一扫连接
     *
     * @param req
     * @return
     */
    String getFriendSweepShortUrl(ShortLinkReq req);

    /**
     * 根据机器ID获取短链接
     *
     * @param machineId 机器ID
     * @return 短链接
     */
    String getMachineShortLink(String machineId);

    /**
     * 获取活动分享短链
     * 其实返回的是微信的授权链接
     * 不推荐使用
     *
     * @param privilegeShareShortLinkDTO
     * @return
     */
    @Deprecated
    String getPrivilegeShareShortLink(PrivilegeShareShortLinkDTO privilegeShareShortLinkDTO);

    /**
     * 使用默认的t 生成短链
     * @param url url
     * @return 短链
     */
    String generateShortUrl(String url);

    /**
     * 生成短链
     * @param shortLinkType 为空的话使用t 否则使用指定的
     * @param url url
     * @return 短链
     */
    String generateShortUrl(String url, ShortLinkTypeEnum shortLinkType);
}
