package com.bxm.localnews.common.param;

import com.bxm.newidea.component.vo.PageParam;
import lombok.Data;

/**
 * t_base_domain_publish
 * @author
 */
@Data
public class DomainPublishListParam extends PageParam {

    private Long id;

    /**
     * 域名id
     */
    private String domain;

    /**
     * 域名id
     */
    private Long domainId;

    /**
     * 投放场景 0: 站内H5 1：站内淘宝授权 2: 短链 3: 站外分享域名 4: 站外分享落地页域名  5: 站外微信用户授权中间页 6: 站外微信支付中间页
     */
    private Byte scene;

    /**
     * 如果域名场景是落地页域名 则该字段标识落地页场景 0: 非落地页域名 1: 站外内容落地页 2: 站外推广落地页 3: 站外活动落地页
     */
    private Byte viewScene;

    /**
     * 如果涉及到公众号授权，则当前域名绑定的公众号信息
     */
    private String appId;

    /**
     * 状态 1可用 0不可用
     */
    private Byte status;
}