/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AppVersionMapper;
import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
@RefreshScope
public class AppVersionServiceImpl
implements AppVersionService {
    private AppVersionMapper appVersionMapper;
    private BizConfigProperties bizConfigProperties;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public AppVersionServiceImpl(AppVersionMapper appVersionMapper, BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter) {
        this.appVersionMapper = appVersionMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public boolean inWhiteList(String phone) {
        return this.bizConfigProperties.getWhiteList().contains(phone);
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam) {
        AppVersionDTO appVersionDTO = new AppVersionDTO();
        List<AppVersionDTO> appVersionDTOS = this.getAllAppVersion();
        if (CollectionUtils.isNotEmpty(appVersionDTOS)) {
            for (AppVersionDTO app : appVersionDTOS) {
                if (!app.getVersion().equals(basicParam.getVersion()) || !app.getCode().equals(basicParam.getChnl())) continue;
                appVersionDTO = app;
                break;
            }
        }
        return appVersionDTO;
    }

    private List<AppVersionDTO> getAllAppVersion() {
        TypeReference<List<AppVersionDTO>> typeReference = new TypeReference<List<AppVersionDTO>>(){};
        List appVersionDTOS = (List)this.redisStringAdapter.get(this.getAppChannelListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)appVersionDTOS)) {
            appVersionDTOS = this.appVersionMapper.getAllAppVersion();
            this.redisStringAdapter.set(this.getAppChannelListKey(), (Object)appVersionDTOS);
        }
        return appVersionDTOS;
    }

    private KeyGenerator getAppChannelListKey() {
        return RedisConfig.BASE_APPVERSION_CHANNEL.copy().appendKey((Object)"list");
    }
}

