/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AreaDivisionMapper;
import com.bxm.localnews.base.service.AreaService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.AreaDivision;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaServiceImpl
implements AreaService {
    private AreaDivisionMapper areaDivisionMapper;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AreaServiceImpl(AreaDivisionMapper areaDivisionMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.areaDivisionMapper = areaDivisionMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public AreaDivision getCacheArea(String code) {
        AreaDivision area = (AreaDivision)this.redisHashMapAdapter.get(RedisConfig.AREA_INFO_MAP, code, AreaDivision.class);
        if (area == null) {
            area = this.areaDivisionMapper.selectByCode(code);
            if (area != null) {
                this.redisHashMapAdapter.put(RedisConfig.AREA_INFO_MAP, code, (Object)area);
            } else {
                area = new AreaDivision();
            }
        }
        return area;
    }

    @Override
    public String getBizLogArea(String code) {
        if (null != code && code.length() >= 6) {
            String result = this.getCacheArea(code.substring(0, 2)).getName() + "," + this.getCacheArea(code.substring(0, 4) + "00000000").getName();
            String lastLevel = code.substring(4, 6);
            if (!"00".equals(lastLevel)) {
                result = result + "," + this.getCacheArea(code.substring(0, 6) + "000000").getName();
            }
            return result;
        }
        return null;
    }
}

